package com.yidianling.home.ui.behavior;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import com.google.android.material.appbar.AppBarLayout;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.OverScroller;
import android.widget.RelativeLayout;

import com.ydl.ydlcommon.utils.ColorCalculateUtils;
import com.ydl.ydlcommon.utils.DisplayUtils;
import com.yidianling.home.ui.scrollView.DisInterceptNestedScrollView;

/**
 * Created by haorui on 2019/3/2.
 * Des:
 */
public class HomeAppBarLayoutBehavior extends AppBarLayout.Behavior {
    private static final String TAG = "overScroll";
    private static final String TAG_TOOLBAR = "toolbar";
    private static final String TAG_TOOLBAR_BG = "toolbar_bg";
    private static final String TAG_MIDDLE_BUT = "middle_but_layout";
    private static final String TAG_SEARCH_INPUT = "tag_search_input";
    private static final String TAG_SEARCH_INPUT_BG = "tag_search_input_bg";
    private static final String TAG_SEARCH_INPUT_EDIT = "tag_search_input_edit";
    private static final String TAG_SEARCH_INPUT_IMG = "tag_search_input_img";
    private View mTargetView;
    private View mToolBarBg;
    private ViewGroup middleLayout;//咨询按钮布局
    private RelativeLayout inputLayout;//输入框布局
    private boolean isRecovering = false;//是否正在自动回弹中

    private float INPUT_LEFT_OFFSET ;//52dp - 15dp
    private float INPUT_RIGHT_OFFSET ;//38dp - 15dp
    private float INPUT_HEIGHT_OFFSET ;//44dp - 32dp
    private float INPUT_SEARCH_IMAGE_OFFSET ;//15dp - 10dp
    private float INPUT_SEARCH_IMAGE_ORIGIN_OFFSET;//15dp
    private float INPUT_ORIGIN_HEIGHT;
    private int inputOriginMargin;


    private View inputLayoutBg;
    private GradientDrawable inputBgDrawable;
    private EditText inputLayoutEdit;
    private ImageView inputLayoutImg;
    private OverScroller mScroller1;
    private float mInputLastScale ;
    private CoordinatorLayout.LayoutParams mLayoutParams;
    private RelativeLayout.LayoutParams mLayoutImageParams;

    public HomeAppBarLayoutBehavior() {

    }

    public HomeAppBarLayoutBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        INPUT_LEFT_OFFSET = DisplayUtils.dp2px(context,23);
        INPUT_RIGHT_OFFSET = DisplayUtils.dp2px(context,37);
        INPUT_HEIGHT_OFFSET = DisplayUtils.dp2px(context,11);
        INPUT_ORIGIN_HEIGHT = DisplayUtils.dp2px(context,44);
        INPUT_SEARCH_IMAGE_OFFSET = DisplayUtils.dp2px(context,4);
        INPUT_SEARCH_IMAGE_ORIGIN_OFFSET = DisplayUtils.dp2px(context,10);

    }


    @Override
    public boolean onLayoutChild(CoordinatorLayout parent, AppBarLayout abl, int layoutDirection) {
        boolean handled = super.onLayoutChild(parent, abl, layoutDirection);

        if (mToolBarBg == null) {
            mToolBarBg = (View) parent.findViewWithTag(TAG_TOOLBAR_BG);
        }

        if (middleLayout == null) {
            middleLayout = (ViewGroup) parent.findViewWithTag(TAG_MIDDLE_BUT);
        }

        if (inputLayout == null) {
            inputLayout = (RelativeLayout) parent.findViewWithTag(TAG_SEARCH_INPUT);
            inputLayoutBg = parent.findViewWithTag(TAG_SEARCH_INPUT_BG);
            inputLayoutEdit = (EditText) parent.findViewWithTag(TAG_SEARCH_INPUT_EDIT);
            inputLayoutImg = (ImageView) parent.findViewWithTag(TAG_SEARCH_INPUT_IMG);

            inputBgDrawable = (GradientDrawable) inputLayoutBg.getBackground();
            mLayoutParams = (CoordinatorLayout.LayoutParams) inputLayout.getLayoutParams();
            inputOriginMargin = mLayoutParams.leftMargin;

            mLayoutImageParams = (RelativeLayout.LayoutParams) inputLayoutImg.getLayoutParams();
        }

        if (mTargetView == null) {
            mTargetView = parent.findViewWithTag(TAG);
            if (mTargetView != null) {
                initial(abl);
            }
        }

        abl.addOnOffsetChangedListener(new AppBarLayout.OnOffsetChangedListener() {


            @Override
            public final void onOffsetChanged(AppBarLayout appBarLayout, int i) {
                float scale =  Float.valueOf(Math.abs(i)) / Float.valueOf(appBarLayout.getTotalScrollRange());
                mToolBarBg.setAlpha( scale);

                float leftMargin =  inputOriginMargin + (INPUT_LEFT_OFFSET*scale);
                float rightMargin =  inputOriginMargin + (INPUT_RIGHT_OFFSET*scale);
                mLayoutParams.setMargins((int)leftMargin,0,(int) rightMargin,0);
                mLayoutParams.height = (int) (INPUT_ORIGIN_HEIGHT - (scale*INPUT_HEIGHT_OFFSET));
                inputLayout.setLayoutParams(mLayoutParams);

                float imageRightMargin =  INPUT_SEARCH_IMAGE_ORIGIN_OFFSET - (INPUT_SEARCH_IMAGE_OFFSET*scale);
                mLayoutImageParams.setMargins((int)INPUT_SEARCH_IMAGE_ORIGIN_OFFSET,0,(int) imageRightMargin,0);
                inputLayoutImg.setLayoutParams(mLayoutImageParams);

                //设置圆角
                inputBgDrawable.setCornerRadius(12+(40*scale));
               if(Math.abs(scale-mInputLastScale)>0.25) {
                    //设置字体/图标颜色 4次
                    inputLayoutEdit.setHintTextColor(Color.parseColor(ColorCalculateUtils.calculateColor("#FFB3B3B3","#A4999999",scale)));
                    inputLayoutImg.setColorFilter(Color.parseColor(ColorCalculateUtils.calculateColor("#FF999999","#FFB3B3B3",scale)));
//                    inputLayoutEdit.setTextColor(Color.parseColor(ColorCalculateUtils.calculateColor("#FF444444","#A4FFFFFF",scale)));
                    mInputLastScale  = scale;
                }
//                inputLayoutImg.setAlpha((float) (1- (0.4*scale)));
            }

        });
        return handled;
    }

    @Override
    public boolean onStartNestedScroll(CoordinatorLayout parent, AppBarLayout child, View directTargetChild, View target, int nestedScrollAxes, int type) {
        if (target instanceof DisInterceptNestedScrollView)
            return true;//middleLayout
        return super.onStartNestedScroll(parent, child, directTargetChild, target, nestedScrollAxes,type);
    }

    private void initial(AppBarLayout abl) {
        abl.setClipChildren(false);
    }
}