package com.yidianling.home.ui.view

import android.content.Context
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import com.ydl.ydl_image.manager.YDLImageCacheManager
import com.ydl.ydlcommon.utils.URLUtils
import com.yidianling.common.tools.RxImageTool
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeConsultBean
import kotlinx.android.synthetic.xlzx.home_consult_item_view.view.*
import kotlinx.android.synthetic.xlzx.home_item_tag.view.*

/**
 * @author jiucheng
 * @描述:首页咨询理解模块--专家个人信息view
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/2/16
 */
class HomeConsultItemView(private var mContext: Context, private var homeEvent: IHomeBaseEvent?) :
    FrameLayout(mContext) {
    private var dp70 = 0

    init {
        initView()

        dp70 = RxImageTool.dip2px(70f)
    }

    private fun initView() {
        var params = FrameLayout.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )
        layoutParams = params
        View.inflate(context, R.layout.home_consult_item_view, this)
    }

    fun setData(bean: HomeConsultBean.ListBean?, position: Int, isLast: Boolean, cateId: String?) {
        if (bean == null) {
            visibility = View.GONE
            return
        }
        //设置头像
        setHead(bean)
        //设置名称
        tv_consult_name.text = bean.name
        //咨询师标签
        setTag(bean)
        //设置接通率文案
        setConnection(bean)
        //设置向TA咨询人数
        setConfideNum(bean)

        setOnClickListener {
            val url = URLUtils.appendParmas(bean.linkUrl, "cateId", cateId)
            homeEvent!!.consultItemClick(url, bean.doctorId)
        }
    }

    /**咨询师标签*/
    private fun setTag(bean: HomeConsultBean.ListBean) {
        ll_tags.removeAllViews()
        if (!TextUtils.isEmpty(bean.tags)) {
            val tagList = bean.tags?.split("|")
            tagList.forEachIndexed { index, tag ->
                if (index < 2 && !TextUtils.isEmpty(tag)) {
                    val view = LayoutInflater.from(context)
                        .inflate(R.layout.home_item_tag, ll_tags, false)
                    view.tvTag.text = tag
                    ll_tags.addView(view)
                }
            }
        }
    }

    /**
     * 设置头像
     */
    private fun setHead(bean: HomeConsultBean.ListBean) {
        YDLImageCacheManager.showImage(mContext, bean?.head, img_consult_head)
    }

    /**
     * 设置向TA咨询人数
     */
    private fun setConfideNum(bodyBean: HomeConsultBean.ListBean) {
        if (TextUtils.isEmpty(bodyBean.zixunOrderNum.toString())) {
            tv_consult_num.visibility = View.GONE
            tv_tv_consult_num_content.visibility = View.GONE
        } else {
            tv_consult_num.visibility = View.VISIBLE
            tv_tv_consult_num_content.visibility = View.VISIBLE
            tv_consult_num.text = bodyBean.zixunOrderNum.toString()
        }
    }

    /**
     * 设置接通率文案
     */
    private fun setConnection(bodyBean: HomeConsultBean.ListBean) {
        if (TextUtils.isEmpty(bodyBean.feedbackRate.toString())) {
            tv_feedback_rate.visibility = View.INVISIBLE
            tv_feedback_rate_content.visibility = View.INVISIBLE
        } else {
            tv_feedback_rate.visibility = View.VISIBLE
            tv_feedback_rate_content.visibility = View.VISIBLE
            try {
                val dd = bodyBean.feedbackRate/5.00f
                val str = String.format("%.0f",dd*100f)+"%"
                tv_feedback_rate.text = str
            }catch (e:Exception){
                e.printStackTrace()
            }
        }
    }

}
