package com.yidianling.home.ui.view

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.yidianling.common.tools.RxImageTool
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeFMBean
import kotlinx.android.synthetic.xlzx.home_intelligent_item_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 心灵电台模块item
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/14
 */
class HomeIntelligentItemView(
    private val mContext: Context,
    private var homeEvent: IHomeBaseEvent?
) : LinearLayout(mContext) {

    private var params: LinearLayout.LayoutParams? = null

    init {
        initView()
    }

    private fun initView() {
        orientation = VERTICAL
        params = LinearLayout.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )
        layoutParams = params
        View.inflate(mContext, R.layout.home_intelligent_item_view, this)

    }

    /**
     * 刷新数据
     */
    fun updateData(bean: HomeFMBean.ListBean) {
        homeModuleIntelligentItemViewTitle.text = bean.name
        homeModuleIntelligentItemViewHits.text = bean.hits.toString()
        this.setOnClickListener { homeEvent?.fmItemClick(bean) }
        iv_fm_play.setOnClickListener { homeEvent?.fmPlayClick(bean) }
    }

    /**
     * 电台第二个item会有一个marginTop值
     */
    fun setTopMargin() {
        params?.topMargin = RxImageTool.dp2px(16f)
        layoutParams = params
    }

    /**
     * 电台最后一个item会有一个marginBottom值
     */
    fun setBottomMargin() {
        params?.bottomMargin = RxImageTool.dp2px(16f)
        layoutParams = params
    }
}