package com.yidianling.home.adapter

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.ydl.ydl_image.module.GlideApp
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeHeaderBean
import kotlinx.android.synthetic.main.home_category_list_item.view.*

/**
 * Created by zqk on 17-9-20.
 */
class CategoryAdapter(
    private val context: Context,
    private val cateList: MutableList<HomeHeaderBean.CategoryGoldListDataBean>,
    private val homeEvent: IHomeBaseEvent
) : RecyclerView.Adapter<CategoryAdapter.ViewHolder>() {

    override fun getItemCount(): Int = cateList.size

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val itemView =
            LayoutInflater.from(context).inflate(R.layout.home_category_list_item, parent, false)
        return ViewHolder(itemView)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        GlideApp.with(context).load(cateList[position].icon)
            .centerCrop().into(holder.category_img)
        holder.category_text.text = cateList[position].title
        holder.itemView.setOnClickListener {
            homeEvent.categoryClick(cateList[position])
        }
    }

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        val category_img = itemView.category_img
        val category_text = itemView.category_text

    }
}