package com.yidianling.home.dialog

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.Window
import com.yidianling.home.R
import com.ydl.ydl_image.module.GlideApp
import kotlinx.android.synthetic.ydl.home_dialog_guide_activity.*
import java.util.*

/**
 * 首页活动引导弹窗
 */
class ActivityGuideDialog : Dialog {

    private var imgUrl: String? = null
    private var title: String? = null

    constructor(context: Context, imgUrl: String?, title: String?) : super(
        context,
        R.style.activityDialog
    ) {
        this.imgUrl = imgUrl
        this.title = title
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        window.setBackgroundDrawableResource(android.R.color.transparent)

        setContentView(R.layout.home_dialog_guide_activity)

        initView()
    }

    private fun initView() {

        c_body.setOnClickListener {
            dismiss()
        }

        tv_content.text = this.title

        GlideApp.with(context).load(imgUrl).into(img_activity)

        //3秒自动消失
        Timer().schedule(object : TimerTask() {
            override fun run() {
                dismiss()
            }
        }, 3000)
    }

}