package com.yidianling.home.event

import android.content.Context
import com.ydl.ydl_router.manager.YDLRouterManager
import com.ydl.ydl_router.manager.YDLRouterParams
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.ydl.ydlcommon.utils.Utils
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.yidianling.home.constants.HomeBIConstants
import com.yidianling.home.constract.IHomeContract

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 首页点击事件实现类
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
open class HomeImpl(context: Context, homeView: IHomeContract.View) : HomeBaseImpl(context, homeView), IHomeEvent {
    override fun museMoreClick(dataJson: String) {
        if (Utils.isFastClick()) {
            //防止连击
            return
        }
        ActionCountUtils.count(HomeBIConstants.YDL_HOME_ZHUMIANMINGXIANG)
        YDLRouterManager.router(
            IYDLRouterConstant.ROUTER_MUSE,
            YDLRouterParams().putExtra(IYDLRouterConstant.MUSIC_URL, "")
                .putExtra(IYDLRouterConstant.DATA_JSON, dataJson))
    }

    override fun museClick(musicUrl: String, dataJson: String,iconName:String) {
        if (Utils.isFastClick()) {
            //防止连击
            return
        }
        ActionCountUtils.count(HomeBIConstants.YDL_HOME_ZHUMIANICON,iconName)
        YDLRouterManager.router(
            IYDLRouterConstant.ROUTER_MUSE,
            YDLRouterParams().putExtra(IYDLRouterConstant.MUSIC_URL, musicUrl)
                .putExtra(IYDLRouterConstant.DATA_JSON, dataJson))
    }

}
