package com.yidianling.home.http

import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.home.model.bean.MeditationModuleBean
import com.yidianling.home.model.bean.MuseModuleBean
import io.reactivex.Observable

/**
 * @author jiucheng
 * @描述:首页接口实现类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/22
 */
class HomeHttp {

    companion object {
        fun getInstance(): HomeHttp {
            return Holder.INSTANCE
        }
    }

    object Holder {
        val INSTANCE = HomeHttp()
    }

    private var homeApi: HomePagerApi? = null

    private fun getHomePagerApi(): HomePagerApi {
        if (homeApi == null) {
            homeApi = YDLHttpUtils.obtainApi(HomePagerApi::class.java)
        }
        return homeApi!!
    }

    //壹点冥想
    fun newMuseRequest(): Observable<BaseAPIResponse<MuseModuleBean>> {
        return getHomePagerApi().getMuseData()
    }


}