package com.yidianling.home.ui.view

import android.app.Activity
import android.app.Dialog
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.text.TextUtils
import com.yidianling.home.R
import com.yidianling.home.model.bean.CouponBean
import kotlinx.android.synthetic.ydl.home_dialog_coupon.*

/**
 * @author jiucheng
 * @描述:首页优惠券弹窗
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/6
 */
class CouponDialog : Dialog {
    private var activity: Activity? = null
    var status: Int = STATUS_RECEIVER
    var couponBean: CouponBean? = null
    var list: List<CouponBean>? = null
    var listener: OnClickEnsureListener? = null

    companion object {
        var STATUS_RECEIVER = 0 //立即领取
        var STATUS_GET = 1 //查看我的卡券
    }


    constructor(activity: Activity?, list: List<CouponBean>, listener: OnClickEnsureListener?) : super(activity) {
        this.activity = activity
        this.couponBean = list[0]
        this.list = list
        this.listener = listener
    }

    fun updateStatus(status: Int) {
        this.status = status
        updateUiByStatus()
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.home_dialog_coupon)
        setCanceledOnTouchOutside(false)
        window.setBackgroundDrawable(ColorDrawable())
        if (couponBean != null) {
            if (!TextUtils.isEmpty(couponBean!!.title)) {
                tv_title.text = couponBean!!.title
            }
            tv_duration.text = couponBean!!.validity
            if (TextUtils.equals("1", couponBean!!.type)) {
                tv_money.text = couponBean!!.amount
                tv_unit.text = "元"
            } else {
                tv_money.text = (couponBean!!.discount?:"0".toFloat() * 10).toString()
                tv_unit.text = "折"
            }
            tv_limit.text = couponBean!!.condition
        }
        updateUiByStatus()
        tv_ensure.setOnClickListener {
            if (listener != null) {
                listener!!.clickEnsure(status)
            }
            if (status == STATUS_GET) {
                dismiss()
            }
        }
        iv_close.setOnClickListener {
            dismiss()
        }
    }

    private fun updateUiByStatus() {
        var title = ""
        var ensureText = ""
        var iamge = 0
        when (status) {
            STATUS_RECEIVER -> {
                if (list!!.size > 1) {
                    title = "获得${list!!.size}张新的优惠券"
                } else {
                    title = "获得新优惠券"
                }
                ensureText = "立即领取"
                iamge = R.drawable.home_coupon_receiver
            }
            STATUS_GET -> {
                if (list!!.size > 1) {
                    title = "获得${list!!.size}张新的优惠券"
                } else {
                    title = "恭喜您，领取成功"
                }
                ensureText = "查看我的卡券"
                iamge = R.drawable.home_coupon_success
            }
        }
        iv_title.setImageResource(iamge)
        tv_status.text = title
        tv_ensure.text = ensureText
    }

    interface OnClickEnsureListener {
        fun clickEnsure(status: Int)
    }

    override fun show() {
        if (null == activity || activity!!.isFinishing) {
            return
        }
        super.show()
    }
}