package com.yidianling.home.ui.view

import android.content.Context
import android.graphics.PointF
import android.util.AttributeSet
import android.util.Log
import android.view.MotionEvent
import androidx.viewpager.widget.ViewPager


/**
 * @author yuanWai
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/3/22
 */
class HomeCategoryViewPager : ViewPager {

    constructor(context: Context) : super(context){

    }

    constructor(context: Context,attributeSet: AttributeSet) : super(context,attributeSet){

    }

    /** 触摸时按下的点  */
    private var downP = PointF()
    /** 触摸时当前的点  */
    private var curP = PointF()
    /** 触摸抬起的点 */
    private var upP = PointF()

    private var mOnSingleTouchListener: OnSingleTouchListener? = null

    override fun onInterceptTouchEvent(arg0: MotionEvent): Boolean {
        //当拦截触摸事件到达此位置的时候，返回true，
        //说明将onTouch拦截在此控件，进而执行此控件的onTouchEvent
        return true
    }

    override fun onTouchEvent(arg0: MotionEvent): Boolean {
        //每次进行onTouch事件都记录当前的按下的坐标
        curP.x = arg0.x
        curP.y = arg0.y

        if (arg0.action == MotionEvent.ACTION_DOWN) {
            //记录按下时候的坐标
            //切记不可用 downP = curP ，这样在改变curP的时候，downP也会改变
            downP.x = arg0.x
            downP.y = arg0.y
            //此句代码是为了通知他的父ViewPager现在进行的是本控件的操作，不要对我的操作进行干扰
//            parent.requestDisallowInterceptTouchEvent(true)
        }

        if (arg0.action == MotionEvent.ACTION_MOVE) {
            //此句代码是为了通知他的父ViewPager现在进行的是本控件的操作，不要对我的操作进行干扰
//            parent.requestDisallowInterceptTouchEvent(true)
        }

        if (arg0.action == MotionEvent.ACTION_UP) {
            upP.x = arg0.x
            upP.y = arg0.y
            val x = Math.abs(upP.x - downP.x)
            val y = Math.abs(upP.y - downP.y)
            val z = Math.sqrt(((x * x) + (y * y)).toDouble())
            val jiaodu = Math.round((Math.asin(y / z) / Math.PI * 180))// 角度
            if (upP.y < downP.y && jiaodu > 45) {// 上
                Log.d("onTouchEvent-ACTION_UP", "角度:$jiaodu, 動作:上")
                parent.requestDisallowInterceptTouchEvent(false)
            } else if (upP.y > downP.y && jiaodu > 45) {// 下
                Log.d("onTouchEvent-ACTION_UP", "角度:$jiaodu, 動作:下")
                parent.requestDisallowInterceptTouchEvent(false)
            } else if (upP.x < downP.x && jiaodu <= 45) {// 左
                Log.d("onTouchEvent-ACTION_UP", "角度:$jiaodu, 動作:左")
                // 原方向不是向右時，方向轉右
                parent.requestDisallowInterceptTouchEvent(true)
            } else if (upP.x > downP.x && jiaodu <= 45) {// 右
                Log.d("onTouchEvent-ACTION_UP", "角度:$jiaodu, 動作:右")
                // 原方向不是向左時，方向轉右
                parent.requestDisallowInterceptTouchEvent(true)
            }
            //在up时判断是否按下和松手的坐标为一个点
            //如果是一个点，将执行点击事件，这是我自己写的点击事件，而不是onclick
            if (downP.x == curP.x && downP.y == curP.y) {
                onSingleTouch()
                return true
            }
        }
        return super.onTouchEvent(arg0)
    }

    /**
     * 单击
     */
    private fun onSingleTouch() {
        mOnSingleTouchListener?.onSingleTouch()
    }

    fun setOnSingleTouchListener(onSingleTouchListener : OnSingleTouchListener){
        mOnSingleTouchListener = onSingleTouchListener
    }

    /**
     * 创建点击事件接口
     * @author wanpg
     */
    interface OnSingleTouchListener {
        fun onSingleTouch()
    }
}