package com.yidianling.home.ui.view

import android.annotation.SuppressLint
import android.content.Context
import android.text.TextUtils
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import com.blankj.utilcode.util.SpanUtils
import com.bumptech.glide.Glide
import com.bumptech.glide.load.engine.DiskCacheStrategy
import com.ydl.ydl_image.module.GlideApp
import com.yidianling.common.tools.RxImageTool
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeConfideBean
import kotlinx.android.synthetic.ydl.home_confide_item_layout.view.*

/**
 * @author jiucheng
 * @描述:首页倾诉模块--专家个人信息view
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/2/16
 */
class HomeConfideExpertInfoView(private var mContext: Context, private var homeEvent: IHomeBaseEvent?) : FrameLayout(mContext) {
    private var dp70 = 0

    init {
        initView()

        dp70 = RxImageTool.dip2px(70f)
    }

    private fun initView() {
        var params = FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = params
        View.inflate(context, R.layout.home_confide_item_layout, this)
    }

    fun setData(bean: HomeConfideBean.BodyBean?, position: Int, isLast: Boolean) {
        if (bean == null) {
            visibility = View.GONE
            return
        }
        //设置头像
        setHead(bean)

        setListenAndScore(bean)

        setFreeStatus(bean)

        setConfideTag(bean)

        setLineStatus(bean)

        //设置名称
        tv_name.text = bean.confidedName
        //设置倾诉标签View的最大宽度
//        tag_view.setConfideWidth()
        //咨询师标签
//        tag_view.initData(bean.confidedTag as MutableList<String>)
        //设置向TA倾诉人数
        setConfideNum(bean)
        //设置接通率文案
        setConnection(bean)
        //设置向TA倾诉按钮状态
        setConfideButton(bean)
        //设置红包、原价
//        setCoupon(bean)

        //设置咨询师简介
        tv_content.text = bean.confideContent

        //最后一项显示分割线
        if (isLast) {
            view_line.visibility = View.GONE
        } else {
            view_line.visibility = View.VISIBLE
        }
        this.setOnClickListener {
            homeEvent!!.confideClick(bean.linkUrl, bean.confidedId.toString(), bean.doctorId, bean.uid.toString())
        }
    }

    /**
     * 设置头像
     */
    private fun setHead(bean: HomeConfideBean.BodyBean) {
//        val op = SimpleImageOpConfiger()
//        op.errorPic = R.drawable.platform_head_place_hold_pic
//        op.loadingPic = R.drawable.platform_head_place_hold_pic
//        op.transform = 0
//        YDLImageCacheManager.showImage(mContext, bean.confidedIcon, img_head, op)


        //这样处理 是防止 滑动过程中 反复去加载图片
        if (!TextUtils.isEmpty(bean.confidedIcon) && img_head.getTag(R.id.img_head) != bean.confidedIcon) {
            GlideApp.with(context)
                .load(bean.confidedIcon)
//                .override(dp96, dp96)
                .into(img_head)
            img_head.setTag(R.id.img_head, bean.confidedIcon)
        }

    }

    /**
     * 设置向TA倾诉人数
     */
    private fun setConfideNum(bodyBean: HomeConfideBean.BodyBean) {
        if (TextUtils.isEmpty(bodyBean.confideNum)) {
            tv_confideNum.visibility = View.GONE
            tv_tv_confideNumContent.visibility = View.GONE
        } else {
            tv_confideNum.visibility = View.VISIBLE
            tv_tv_confideNumContent.visibility = View.VISIBLE
            tv_confideNum.text = bodyBean.confideNum
        }
    }

    /**
     * 设置接通率文案
     */
    private fun setConnection(bodyBean: HomeConfideBean.BodyBean) {
        if (TextUtils.isEmpty(bodyBean.confideConnection)) {
            tv_Connection.visibility = View.INVISIBLE
            tv_ConnectionContent.visibility = View.INVISIBLE
        } else {
            tv_Connection.visibility = View.VISIBLE
            tv_ConnectionContent.visibility = View.VISIBLE
            tv_Connection.text = bodyBean.confideConnection
        }
    }

    /**
     * 设置向TA倾诉按钮状态
     */
    private fun setConfideButton(bodyBean: HomeConfideBean.BodyBean) {
        when (bodyBean.confideLine) {//1在线 2离线 3通话中  4继续倾诉
            1 -> {
                tv_confide.setBackgroundResource(R.drawable.home_confide_line_1)
            }
            2 -> {
                tv_confide.setBackgroundResource(R.drawable.home_confide_line_2)
            }
            3 -> {
                tv_confide.setBackgroundResource(R.drawable.home_confide_line_3)
            }
            4 -> {
                tv_confide.setBackgroundResource(R.drawable.home_confide_line_4)
            }
        }
        tv_confide.setOnClickListener {
            if (bodyBean.confideLine == 2) {//喊他上线  私聊
                homeEvent!!.toChatForMsg(bodyBean.uid.toString())
            } else {
                homeEvent!!.confideClick(bodyBean.linkUrl, bodyBean.confidedId.toString(), bodyBean.doctorId, bodyBean.uid.toString())
            }
        }
    }


    private fun setListenAndScore(bodyBean: HomeConfideBean.BodyBean) {
        SpanUtils.with(price_content).append(bodyBean.confideFee)
            .setForegroundColor(resources.getColor(R.color.home_confide_fe6040)).setFontSize(18, true)
            .append("元").setForegroundColor(resources.getColor(R.color.home_confide_fe6040))
            .setFontSize(11, true)
            .append("/25分钟").setForegroundColor(resources.getColor(R.color.home_confide_aaaeba))
            .setFontSize(11, true)
            .create()
        tv_score.text = bodyBean.confidePraiseScore
    }

    /**
     * 设置在线状态
     */
    private fun setLineStatus(bodyBean: HomeConfideBean.BodyBean) {
        when (bodyBean.confideLine) {//1在线 2离线 3通话中
            1, 4 -> {
                tv_online.text = "在线"
                tv_online.setBackgroundResource(R.drawable.home_confide_online_main)
            }
            2 -> {
                tv_online.text = "离线"
                tv_online.setBackgroundResource(R.drawable.home_confide_offline_bg)
            }
            3 -> {
                tv_online.text = "通话中"
                tv_online.setBackgroundResource(R.drawable.home_confide_online_main)
            }
        }
    }

    private fun setConfideTag(bodyBean: HomeConfideBean.BodyBean) {
        if (null == bodyBean.confidedTag || bodyBean.confidedTag!!.isEmpty()) {
            return
        }
        var i = 0
        val sb = StringBuilder()
        for (tag in bodyBean.confidedTag!!) {
            if (i > 4) break
            sb.append(tag).append(" | ")
            i++
        }
        if (sb.length > 3) {
            sb.setLength(sb.length - 3)
        }
        flowlayout_tag.text = sb.toString()
    }

    private fun setFreeStatus(bodyBean: HomeConfideBean.BodyBean) {
        if (bodyBean.listenFree == true && bodyBean.confideLine == 1) {
            confide_free_logo.visibility = VISIBLE
            Glide.with(context)
                .load(R.drawable.home_confide__free)
                .diskCacheStrategy(DiskCacheStrategy.RESOURCE)
                .into(confide_free_logo)
        } else {
            confide_free_logo.visibility = GONE
        }
    }

    /**
     * 设置红包、原价
     */
    @SuppressLint("SetTextI18n")
    private fun setCoupon(bodyBean: HomeConfideBean.BodyBean) {

//        if(!TextUtils.isEmpty(bodyBean.couponText)){
//            tvCoupon.text = bodyBean.couponText
//            tvCoupon.visibility = View.VISIBLE
//        }else{
//            tvCoupon.visibility = View.GONE
//        }
//        if (TextUtils.isEmpty(bodyBean.confideFee) || TextUtils.isEmpty(bodyBean.couponMoney) || bodyBean.couponMoney!!.toFloat() <= 0){
//            tvOriginalPrice.visibility = View.GONE
//        }else{
//            tvOriginalPrice.visibility = View.VISIBLE
//            val originalBuffer = StringBuffer()
//            originalBuffer.append(bodyBean.confideFee).append("元/次")
//            tvOriginalPrice.text = originalBuffer.toString()
//            //添加删除线
//            tvOriginalPrice.paint.flags = Paint.STRIKE_THRU_TEXT_FLAG
//        }
//        try {
//            val couponMoney = bodyBean.couponMoney!!.toFloat().toInt()
//            val confideFee = bodyBean.confideFee!!.toFloat().toInt()
//
//            if (couponMoney >= confideFee){
//                tv_price.text = "¥0"
//            }else{
//                val price = confideFee - couponMoney
//                tv_price.text = "¥"+price.toString()
//            }
//        }catch (e:Exception){
//            //防止数据类型变化引起奔溃
//        }

    }
}
