package com.yidianling.home.ui.view

import android.app.Activity
import android.content.Context
import android.text.TextUtils
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import com.ydl.ydl_image.config.SimpleImageOpConfiger
import com.ydl.ydl_image.manager.YDLImageCacheManager
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.ydl.ydlcommon.modular.findRouteService
import com.ydl.ydlcommon.utils.StringUtils
import com.ydl.ydlcommon.utils.URLUtils
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.ydl.ydlcommon.view.dialog.CommonDialog
import com.yidianling.common.tools.RxImageTool
import com.yidianling.consultant.api.IConsultantService
import com.yidianling.home.R
import com.yidianling.home.constants.HomeBIConstants
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeConsultBean
import com.yidianling.user.api.service.IUserService
import kotlinx.android.synthetic.ydl.home_consult_item_view.view.*

/**
 * @author jiucheng
 * @描述:首页咨询理解模块--专家个人信息view
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/2/16
 */
class HomeConsultItemView(private var mContext: Context, private var homeEvent: IHomeBaseEvent?) : FrameLayout(mContext) {
    private var dp70 = 0

    init {
        initView()

        dp70 = RxImageTool.dip2px(70f)
    }

    private fun initView() {
        val params = FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = params
        View.inflate(context, R.layout.home_consult_item_view, this)
    }

    fun setData(bean: HomeConsultBean.ListBean?, position: Int, isLast: Boolean,cateId : String?) {
        if (bean == null) {
            visibility = View.GONE
            return
        }

        //设置头像
        setHead(bean)
        //设置名称
        tv_consult_name.text = bean.name
        //咨询师标签
        tag_view.initData(StringUtils.strToList(bean.tags))
        //设置向TA倾诉人数
        setConfideNum(bean)
        //设置接通率文案
        setConnection(bean)
        //设置向TA倾诉按钮状态
        setConfideButton(bean)
        //设置红包、原价
        setPrice(bean)
        this.setOnClickListener {
//            val url = URLUtils.appendParmas(bean.linkUrl,"cateId",cateId)
//            homeEvent!!.consultItemClick(url,bean.doctorId)

            /*ModularServiceManager.provide(IConsultantService::class.java).jumpConsultAssistant(
                mContext as Activity,
                11
            )*/
            //补充点击事件埋点
            ActionCountUtils.count(HomeBIConstants.YDL_USER_EXPERT_INTRODUCTION_CLICK, bean.uid.toString())
            ModularServiceManager.provide(IConsultantService::class.java).dueToTypeJumpAutoOrGuide(
                mContext as Activity,
                11,
                bean.uid,
                bean.linkUrl
            )
            /*val url = URLUtils.appendParmas(bean.linkUrl,"cateId",cateId)
            homeEvent!!.consultItemClick(url,bean.uid.toString())*/
        }
    }

    /**
     * 设置头像
     */
    private fun setHead(bean: HomeConsultBean.ListBean) {
        val op = SimpleImageOpConfiger()
        op.errorPic = R.drawable.platform_head_place_hold_pic
        op.loadingPic = R.drawable.platform_head_place_hold_pic
        op.transform = 0
        YDLImageCacheManager.showImage(mContext, bean.head, img_consult_head, op)
    }

    /**
     * 设置向TA倾诉人数
     */
    private fun setConfideNum(bodyBean: HomeConsultBean.ListBean) {
        if (TextUtils.isEmpty(bodyBean.zixunOrderNum.toString())) {
            tv_consult_num.visibility = View.GONE
            tv_tv_consult_num_content.visibility = View.GONE
        } else {
            tv_consult_num.visibility = View.VISIBLE
            tv_tv_consult_num_content.visibility = View.VISIBLE
            tv_consult_num.text = bodyBean.zixunOrderNum.toString()
        }
    }

    /**
     * 设置接通率文案
     */
    private fun setConnection(bodyBean: HomeConsultBean.ListBean) {
        if (TextUtils.isEmpty(bodyBean.feedbackRate.toString())) {
            tv_feedback_rate.visibility = View.INVISIBLE
            tv_feedback_rate_content.visibility = View.INVISIBLE
        } else {
            tv_feedback_rate.visibility = View.VISIBLE
            tv_feedback_rate_content.visibility = View.VISIBLE
            try {
                val dd = bodyBean.feedbackRate/5.00f
                val str = String.format("%.2f",dd*100f)+"%"
                tv_feedback_rate.text = str
            }catch (e:Exception){
                e.printStackTrace()
            }
        }
    }

    /**
     * 设置咨询按钮事件
     */
    private fun setConfideButton(bodyBean: HomeConsultBean.ListBean) {
        tv_consult_chat.setOnClickListener {
            val userService = findRouteService(IUserService::class.java)
            if (!userService.isBindPhone() && context is Activity) {
                CommonDialog(context)
                    .setMessage("为了及时接收消息通知,请立即绑定手机")
                    .setLeftOnclick("忍痛放弃") {}
                    .setRightClick("果断绑定") {
                        userService.wxBindToInputhonePage(context as Activity) // 跳转绑定手机号页面
                    }
                    .setCancelAble(false)
                    .show()
                return@setOnClickListener
            }
            ModularServiceManager.provide(IConsultantService::class.java).dueToTypeJumpAutoOrGuide(
                mContext as Activity,
                11,
                bodyBean.uid,
                ""
            )
            ActionCountUtils.count(HomeBIConstants.YDL_PRIVATE_CHAT_CLICK)
        }
    }

    private fun setPrice(bodyBean: HomeConsultBean.ListBean) {
        val confideFee = bodyBean.minBookingPrice
        val sb = StringBuffer()
        tv_price.text = sb.append("¥").append(confideFee).toString()
    }
}
