package com.yidianling.home.ui.view

import android.graphics.Rect
import android.view.View
import androidx.recyclerview.widget.RecyclerView
import com.yidianling.home.constract.HomeViewConfig

/**
 * Created by haorui on 2020/3/23.
 * Des:
 */
class HomeSpaceItemDecoration(var mSpace: Int) : RecyclerView.ItemDecoration() {

    override fun getItemOffsets(
        outRect: Rect,
        view: View,
        parent: RecyclerView,
        state: RecyclerView.State
    ) {
        super.getItemOffsets(outRect, view, parent, state)
        val position = parent.getChildAdapterPosition(view)
        when(val viewType = parent.adapter!!.getItemViewType(position)){
            HomeViewConfig.getOrder().bannerIndex->{
                //空banner时不设置间距
                if (viewType!=-1&&HomeViewConfig.getOrder().buttonIndex==null){
                    outRect.bottom = mSpace
                }
            }
            else ->{
                if (HomeViewConfig.getOrder().footerIndex!=null){
                    //底部footer显示时，倒数第一、二个View不设置间距
                    if ( position!=parent.adapter!!.itemCount-1
                            && position!=parent.adapter!!.itemCount-2){
                        outRect.bottom = mSpace
                    }
                }else{
                    outRect.bottom = mSpace
                }
            }
        }
    }
}