package com.yidianling.home.ui.view

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeTestItemBean
import com.ydl.ydl_image.manager.YDLImageCacheManager
import com.yidianling.common.tools.RxImageTool
import kotlinx.android.synthetic.ydl.home_test_item_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 测试*分析模块模块item
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/14
 */
class HomeTestItemView(private val mContext: Context, private var homeEvent: IHomeBaseEvent?) : LinearLayout(mContext) {

    private var params: LinearLayout.LayoutParams? = null

    init {
        initView()
    }

    private fun initView() {
        orientation = VERTICAL
        params = LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = params
        View.inflate(mContext, R.layout.home_test_item_view, this)

    }

    /**
     * 刷新数据
     */
    fun updateData(bean: HomeTestItemBean, isLast: Boolean) {
        tv_test_item_name.text = bean.name
        tv_tested_count.text = bean.testNum.toString()
        YDLImageCacheManager.showImage(mContext, bean?.shareImage, iv_test_item)

        if (isLast) {
            view_test_line.visibility = View.GONE
        } else {
            view_test_line.visibility = View.VISIBLE
        }
        this.setOnClickListener {
            homeEvent?.testItemClick(bean.recommendLinkUrl)

        }
    }

    /**
     * 电台第二个item会有一个marginTop值
     */
    fun setTopMargin() {
        params?.topMargin = RxImageTool.dp2px(16f)
        layoutParams = params
    }

    /**
     * 电台最后一个item会有一个marginBottom值
     */
    fun setBottomMargin() {
        params?.bottomMargin = RxImageTool.dp2px(16f)
        layoutParams = params
    }
}