package com.yidianling.home.ui.view

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.yidianling.home.R
import com.yidianling.home.constract.HomeViewConfig
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeTestItemBean
import kotlinx.android.synthetic.ydl.home_test_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 测试*分析模块
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
class HomeTestView(private val mContext: Context, private var homeEvent: IHomeBaseEvent?) : LinearLayout(mContext) {

    private var cacheList : ArrayList<HomeTestItemBean> = ArrayList()

    init {
        initView()
    }

    private fun initView() {
        orientation = VERTICAL
        val params = LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = params
        View.inflate(mContext, R.layout.home_test_view, this)
        homeModuleIntelligentViewHomeCommonTitleView.setTitle(HomeViewConfig.getOrder().testsTitle)
        homeModuleIntelligentViewHomeCommonTitleView.setOnClickListener {
            homeEvent?.testMoreClick()
        }
    }

    fun initData(list: List<HomeTestItemBean>?) {
        //添加View
        list?.let {
            if (cacheList.size != list?.size) {
                cacheList.clear()
                cacheList.addAll(list!!)
                updateHomeTestItemViewNumber()
            }

            for (index in 0 until homeModuleIntelligentViewAddLayout.childCount) {
                val itemView = homeModuleIntelligentViewAddLayout.getChildAt(index)
                if (itemView is HomeTestItemView) {
                    //第一个这种类型item，需要设置marginTop = 16dp,最后一个item需要设置marginBototm = 16dp
                    if (index == 1) {
                        itemView.setTopMargin()
                    }
//                else if (index == homeModuleIntelligentViewAddLayout.childCount -1) {
//                    itemView.setBottomMargin()
//                }
                    itemView.updateData(list[index], index == list.size - 1)
                } else if (itemView is HomeTestTopItemView) {
                    itemView.updateData(list[index])
                }
            }
        }
    }

    /**
     * 更新itemView的数量以适应新的数据集
     */
    private fun updateHomeTestItemViewNumber() {
        var childCountRecord = homeModuleIntelligentViewAddLayout.childCount
        while (cacheList.size > childCountRecord) {
            if (childCountRecord == 0) {
                homeModuleIntelligentViewAddLayout.addView(HomeTestTopItemView(mContext, homeEvent))
            }else {
                homeModuleIntelligentViewAddLayout.addView(HomeTestItemView(mContext, homeEvent))
            }
            childCountRecord++
        }
        while (cacheList.size < childCountRecord &&
                (homeModuleIntelligentViewAddLayout.getChildAt(childCountRecord -1 ) is HomeTestItemView
                        || homeModuleIntelligentViewAddLayout.getChildAt(childCountRecord -1 ) is HomeTestTopItemView)) {
            homeModuleIntelligentViewAddLayout.removeViewAt(childCountRecord -1 )
            childCountRecord--
        }
    }
}