package com.yidianling.home.utils

import android.animation.Animator
import android.animation.AnimatorListenerAdapter
import android.animation.ValueAnimator
import android.content.Context
import android.graphics.Color
import android.view.View
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.RelativeLayout
import android.widget.TextView
import com.ydl.ydlcommon.utils.ColorCalculateUtils
import com.yidianling.home.constract.IHomeContract
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.common.tools.RxImageTool

/**
 * @author yuanWai
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/3/21
 */
class HomeAnimUtils {

    companion object {
        private var animStart: ValueAnimator? = null
        private var animEnd: ValueAnimator? = null
        private var animSearchStart : ValueAnimator? = null
        private var animSearchEnd : ValueAnimator? = null

        fun startAnim(context: Context, rl_top : RelativeLayout, rlSearch : LinearLayout, imageView : ImageView,tv_home : TextView?) {
            animEnd?.cancel()
            tv_home?.text = "搜索"
            initStartAnim(context,rl_top,rlSearch,imageView)
            animStart?.start()
        }

        private fun initStartAnim(context: Context, rl_top : RelativeLayout, rlSearch : LinearLayout, imageView : ImageView) {
            if (null != animStart){
                return
            }
            val cvWidth = (RxDeviceTool.getScreenWidth(context) - RxImageTool.dip2px(73f)).toFloat()
            val dp105 = RxImageTool.dip2px(105f)
            val dp34 = RxImageTool.dip2px(34f)
            val dp15 = RxImageTool.dip2px(15f)
            val dp7 = RxImageTool.dip2px(7f)
            val dp5 = RxImageTool.dip2px(5f)
            animStart = ValueAnimator.ofFloat(1f, dp105 / cvWidth)
            animStart?.duration = 500// 设置动画运行的时长
            animStart?.startDelay = 0// 设置动画延迟播放时间
            animStart?.repeatCount = 0 // 设置动画重复播放次数 = 重放次数+1 // 动画播放次数 = infinite时,动画无限重复
            animStart?.repeatMode = ValueAnimator.RESTART
            // 设置重复播放动画模式
            // ValueAnimator.RESTART(默认):正序重放
            // ValueAnimator.REVERSE:倒序回放
            // 步骤3：将改变的值手动赋值给对象的属性值：通过动画的更新监听器
            // 设置 值的更新监听器
            // 即：值每次改变、变化一次,该方法就会被调用一次
            animStart?.addUpdateListener { animation ->
                // 获得改变后的值
                val currentValue = animation.animatedValue as Float
                val lp = RelativeLayout.LayoutParams((cvWidth * currentValue).toInt(),dp34)
                lp.setMargins(dp15,dp7,dp15,dp5)
                // 步骤4：将改变后的值赋给对象的属性值，下面会详细说明
                rlSearch.layoutParams = lp
                rl_top.invalidate()
            }
            animStart?.addListener(object : AnimatorListenerAdapter() {
//                override fun onAnimationEnd(animation: Animator) {
//                    imageView.visibility = View.GONE
//                }

                override fun onAnimationStart(animation: Animator?) {
                    imageView.visibility = View.GONE
                }
            })
        }

        fun endAnim(context: Context, rl_top : RelativeLayout, rlSearch : LinearLayout, home_tv : TextView, imageView: ImageView,homeView : IHomeContract.View){
            animStart?.cancel()
            initEndAnim(context,rl_top,rlSearch,home_tv,imageView,homeView)
            animEnd?.start()
        }

        fun initEndAnim(context: Context, rl_top : RelativeLayout, rlSearch : LinearLayout, home_tv : TextView, imageView: ImageView,homeView : IHomeContract.View) {
            if (null != animEnd){
                return
            }
            val cvWidth = (RxDeviceTool.getScreenWidth(context) - RxImageTool.dip2px(73f)).toFloat()
            val dp105 = RxImageTool.dip2px(105f)
            val dp34 = RxImageTool.dip2px(34f)
            val dp15 = RxImageTool.dip2px(15f)
            val dp7 = RxImageTool.dip2px(7f)
            val dp5 = RxImageTool.dip2px(5f)
            animEnd = ValueAnimator.ofFloat(dp105 / cvWidth, 1f)
            animEnd?.duration = 500// 设置动画运行的时长
            animEnd?.startDelay = 0// 设置动画延迟播放时间
            animEnd?.repeatCount = 0 // 设置动画重复播放次数 = 重放次数+1 // 动画播放次数 = infinite时,动画无限重复
            animEnd?.repeatMode = ValueAnimator.RESTART
            // 设置重复播放动画模式
            // ValueAnimator.RESTART(默认):正序重放
            // ValueAnimator.REVERSE:倒序回放
            // 步骤3：将改变的值手动赋值给对象的属性值：通过动画的更新监听器
            // 设置 值的更新监听器
            // 即：值每次改变、变化一次,该方法就会被调用一次
            animEnd?.addUpdateListener { animation ->
                // 获得改变后的值
                val currentValue = animation.animatedValue as Float
                val lp = RelativeLayout.LayoutParams((cvWidth * currentValue).toInt(),dp34)
                lp.setMargins(dp15,dp7,dp15,dp5)
                // 步骤4：将改变后的值赋给对象的属性值，下面会详细说明
                rlSearch.layoutParams = lp
                rl_top.invalidate()
            }
            animEnd?.addListener(object : AnimatorListenerAdapter() {
                override fun onAnimationEnd(animation: Animator) {
                    home_tv.text = homeView.getSearchContent()
                    imageView.visibility = View.VISIBLE
                }
            })
        }

        fun startSearchShow(ll_top_function : LinearLayout, searchBg : View, home_tv : TextView, iv_search_icon:ImageView,img_ad:View){
            if (null == animSearchStart){
                animSearchStart = ValueAnimator.ofFloat(0f, 1f)
                animSearchStart?.duration = 500// 设置动画运行的时长
                animSearchStart?.startDelay = 0// 设置动画延迟播放时间
                animSearchStart?.repeatCount = 0 // 设置动画重复播放次数 = 重放次数+1 // 动画播放次数 = infinite时,动画无限重复
                animSearchStart?.repeatMode = ValueAnimator.RESTART
                animSearchStart?.addUpdateListener { animation ->
                    val currentValue = animation.animatedValue as Float
                    ll_top_function.alpha = currentValue

                    //更改搜索框背景透明度/搜索字体透明度/搜索图标透明度
//                    searchBg.alpha = (1-0.2*currentValue).toFloat()
                    iv_search_icon.setColorFilter(Color.parseColor(ColorCalculateUtils.calculateColor("#FFB3B3B3", "#B8FFFFFF", currentValue)))
                    home_tv.setTextColor(Color.parseColor(ColorCalculateUtils.calculateColor("#FF999999", "#A4FFFFFF", currentValue)))
                    if (img_ad.visibility == View.VISIBLE){
                        searchBg.alpha = 1 - currentValue
                        home_tv.alpha = 1 - currentValue
                    }else{
                        searchBg.alpha = (1-0.8*currentValue).toFloat()
                        home_tv.alpha = 1f
                    }
                }
            }
            animSearchStart?.start()
        }

        fun startSearchHide(ll_top_function : LinearLayout, searchBg : View, home_tv : TextView, iv_search_icon:ImageView,img_ad:View){
            if (null == animSearchEnd){
                animSearchEnd = ValueAnimator.ofFloat(1f, 0f)
                animSearchEnd?.duration = 500// 设置动画运行的时长
                animSearchEnd?.startDelay = 0// 设置动画延迟播放时间
                animSearchEnd?.repeatCount = 0 // 设置动画重复播放次数 = 重放次数+1 // 动画播放次数 = infinite时,动画无限重复
                animSearchEnd?.repeatMode = ValueAnimator.RESTART
                animSearchEnd?.addUpdateListener { animation ->
                    val currentValue = animation.animatedValue as Float
                    ll_top_function.alpha = currentValue

                    //更改搜索框背景透明度/搜索字体透明度/搜索图标透明度
                    searchBg.alpha = (0.2+(0.8*(1-currentValue))).toFloat()
                    iv_search_icon.setColorFilter(Color.parseColor(ColorCalculateUtils.calculateColor("#B8FFFFFF", "#FFB3B3B3", 1-currentValue)))
                    home_tv.setTextColor(Color.parseColor(ColorCalculateUtils.calculateColor("#A4FFFFFF", "#FF999999", 1-currentValue)))
                    if (img_ad.visibility == View.VISIBLE){
                        home_tv.alpha = 1-currentValue
                    }else{
                        home_tv.alpha = 1f
                    }
                }
            }
            animSearchEnd?.start()
        }

        fun clear(){
            if (null != animStart){
                animStart = null
            }
            if (null != animEnd){
                animEnd = null
            }
            if (null != animSearchStart){
                animSearchStart = null
            }
            if (null != animSearchEnd){
                animSearchEnd = null
            }
        }
    }
}