package com.yidianling.avchatkit.common.widgets;

import android.util.Pair;
import android.widget.ImageView;
import android.widget.TextView;

import com.yidianling.im.R;
import com.yidianling.avchatkit.common.adapter.TViewHolder;

public class MultiSelectDialogViewHolder extends TViewHolder {

    private TextView textView;
    private ImageView imageView;


    @Override
    protected int getResId() {
        return R.layout.im_multi_select_dialog_list_item;
    }

    @Override
    protected void inflate() {
        textView = (TextView) view.findViewById(R.id.select_dialog_text_view);
        imageView = (ImageView) view.findViewById(R.id.select_dialog_image_view);
    }

    @Override
    protected void refresh(Object item) {
        if (item instanceof Pair<?, ?>) {
            Pair<String, Boolean> pair = (Pair<String, Boolean>) item;
            textView.setText(pair.first);
            imageView.setPressed(pair.second);
        }
    }

}
