package com.yidianling.im.helper;

import com.netease.nimlib.sdk.NIMClient;
import com.netease.nimlib.sdk.auth.AuthService;
import com.yidianling.im.preference.IMCache;
import com.yidianling.nimbase.common.http.NimHttpClient;
import com.yidianling.uikit.api.NimUIKit;

/**
 * 注销帮助类
 * Created by huangjun on 2015/10/8.
 */
public class LogoutHelper {

    public static void logout() {
        // 清理缓存&注销监听&清除状态
        NimUIKit.logout();
        IMCache.clear();
        NIMClient.getService(AuthService.class).logout();
    }

    private static LogoutHelper instance;

    public static synchronized LogoutHelper getInstance() {
        if (instance == null) {
            instance = new LogoutHelper();
        }

        return instance;
    }

    private LogoutHelper() {
        NimHttpClient.getInstance().init(IMCache.getContext());
    }

}

