package com.yidianling.im.preference;

import com.netease.nimlib.sdk.msg.model.IMMessage;

import java.util.HashMap;
import java.util.Map;

/**
 * 保存聊天临时数据,有人@我时，临时保存此消息
 * Created by hgw on 2017/4/21.
 */

public class ImTempData {

    private static ImTempData imTempData;

    private Map<String,String> tempMap;


    // 暂存@消息，当RecentContact 监听回来时使用，结束后清掉
    private Map<String, IMMessage> cacheMessages = new HashMap<>();

    public synchronized static ImTempData getInstance(){
        if (imTempData==null){
            imTempData = new ImTempData();
        }
        return imTempData;
    }

    private ImTempData(){
        tempMap = new HashMap<>();
    }

    //添加草稿箱消息
    public void addTempMsg(String uid, String content){
        if (content==null || content.equals("")){
            tempMap.remove(uid);
        }else {
            tempMap.put(uid,content);
        }
//        //通知消息列表更新数据
//        EventBus.getDefault().post();
    }
    //获取草稿箱消息
    public String getTempMsg(String uid){
        return tempMap.get(uid);
    }
    //移除草稿箱消息
    public void removeTempMsg(String uid){
        tempMap.remove(uid);
    }

    //添加@消息
    public void addAitMsg(IMMessage imMessage) {
        cacheMessages.put(imMessage.getSessionId(), imMessage);
    }
    //获取@消息
    public IMMessage getAitMsg(String sessionId){
        return cacheMessages.get(sessionId);
    }
    //移除@消息
    public void removeAitMsg(String sessionId){
        cacheMessages.remove(sessionId);
    }
}
