package com.yidianling.im.session.action;


import com.yidianling.avchatkit.AVChatKit;
import com.yidianling.avchatkit.activity.AVChatActivity;
import com.yidianling.uikit.business.uinfo.UserInfoHelper;
import com.netease.nimlib.sdk.avchat.constant.AVChatType;
import com.yidianling.im.R;
import com.yidianling.nimbase.business.session.actions.BaseAction;
import com.yidianling.nimbase.common.ToastHelper;
import com.yidianling.nimbase.common.util.sys.NetworkUtil;


/**
 * Created by hzxuwen on 2015/6/12.
 */
public class AVChatAction extends BaseAction {
    private AVChatType avChatType;

    public AVChatAction(AVChatType avChatType) {
        super(avChatType == AVChatType.AUDIO ? R.drawable.im_message_plus_audio_chat_selector : R.drawable.im_chatbar_audiocall,
                avChatType == AVChatType.AUDIO ? R.string.im_input_panel_audio_call : R.string.im_input_panel_video_call);
        this.avChatType = avChatType;
    }

    @Override
    public void onClick() {
        if (NetworkUtil.isNetAvailable(getActivity())) {
            startAudioVideoCall(avChatType);
        } else {
            ToastHelper.showToast(getActivity(), R.string.im_network_is_not_available);
        }
    }

    /************************ 音视频通话 ***********************/

    public void startAudioVideoCall(AVChatType avChatType) {
        AVChatKit.outgoingCall(getActivity(), getAccount(), UserInfoHelper.getUserDisplayName(getAccount()), avChatType.getValue(), AVChatActivity.FROM_INTERNAL);
    }
}
