package com.yidianling.im.session.action;

import com.netease.nimlib.sdk.NIMClient;
import com.netease.nimlib.sdk.msg.MessageBuilder;
import com.netease.nimlib.sdk.msg.MsgService;
import com.netease.nimlib.sdk.msg.constant.SessionTypeEnum;
import com.netease.nimlib.sdk.msg.model.CustomMessageConfig;
import com.netease.nimlib.sdk.msg.model.IMMessage;
import com.yidianling.im.R;
import com.yidianling.im.dialog.CustomerCardSendRemindDialog;
import com.yidianling.im.session.extension.CustomCustomerServiceCardAttachment;
import com.yidianling.nimbase.business.session.actions.BaseAction;
import com.yidianling.uikit.business.session.helper.MessageListPanelHelper;
/**
 * 发送名片
 * Created by XuJian on 2019/10/29;
 */
public class SendCardAction extends BaseAction {

    /**
     * 构造函数
     */
    public SendCardAction() {
        super(R.drawable.im_chatbar_send_card, R.string.im_input_panel_send_card);
    }

    @Override
    public void onClick() {
        CustomerCardSendRemindDialog dialog = new CustomerCardSendRemindDialog(getActivity(), () -> {
            CustomCustomerServiceCardAttachment customCustomerServiceCardAttachment = new CustomCustomerServiceCardAttachment();
            IMMessage message = MessageBuilder.createCustomMessage(getAccount(), SessionTypeEnum.P2P, customCustomerServiceCardAttachment);
            CustomMessageConfig config = new CustomMessageConfig();
            config.enableUnreadCount = false;
            message.setConfig(config);
            NIMClient.getService(MsgService.class).sendMessage(message, false);
            MessageListPanelHelper.getInstance().notifyAddMessage(message);
        });
        dialog.show();
    }
}
