package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * Created by Wi1ls on 2016/11/28;
 */
public class CustomAttachConsult extends CustomAttachment{
    private final String KEY_URL="url";
    private final String KEY_TITLE="title";

    private String url;
    private String title;

    public CustomAttachConsult() {
        super(CustomAttachmentType.CONSULT);
    }

    public CustomAttachConsult(String url, String title) {
        super(CustomAttachmentType.CONSULT);
        this.url = url;
        this.title = title;
    }

    @Override
    protected void parseData(JSONObject data) {
        this.url=data.getString(KEY_URL);
        this.title=data.getString(KEY_TITLE);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(KEY_URL,url);
        data.put(KEY_TITLE, title);
        return data;
    }

    public String getUrl() {
        return url;
    }

    public String getTitle() {
        return title;
    }
}
