package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * Created by Wi1ls on 2016/11/28;
 */
public class CustomAttachConsultCallStatus extends CustomAttachment{
    private final String KEY_STATUS="status";
    private final String KEY_CALLER="caller";
    private final String KEY_CALLEE="callee";
    private final String KEY_DURATION="duration";
    private final String KEY_IS_CONSULT_ORDER = "isConsultOrder"; //是否是咨询单，true是
    private final String KEY_PULL_CALL = "pullCall"; //是否是咨询单，true是
    private String status;
    private String caller;
    private String callee;
    private String duration;
    private String isConsultOrder;
    private Integer pullCall;//标识是可以拉起通话的 0或空 则不拉起

    public CustomAttachConsultCallStatus() {
        super(CustomAttachmentType.TYPE_CUSTOMER_CONSULT_CALL_STATUS);
    }

    @Override
    protected void parseData(JSONObject data) {
        this.status=data.getString(KEY_STATUS);
        this.caller=data.getString(KEY_CALLER);
        this.callee=data.getString(KEY_CALLEE);
        this.duration=data.getString(KEY_DURATION);
        this.isConsultOrder=data.getString(KEY_IS_CONSULT_ORDER);
        this.pullCall = data.getInteger(KEY_PULL_CALL);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(KEY_STATUS,status);
        data.put(KEY_CALLER, caller);
        data.put(KEY_CALLEE, callee);
        data.put(KEY_DURATION, duration);
        data.put(KEY_IS_CONSULT_ORDER, isConsultOrder);
        data.put(KEY_PULL_CALL, pullCall);
        return data;
    }

    public String getStatus() {
        return status;
    }

    public String getCaller() {
        return caller;
    }

    public String getCallee() {
        return callee;
    }

    public String getDuration() {
        return duration;
    }

    public String getIsConsultOrder() {return isConsultOrder;}

    public Integer getPullCall() {
        return pullCall;
    }
}