package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;
import com.ydl.webview.H5JsBean;

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/04
 */

public class CustomAttachModifyTime extends CustomAttachment {

    private static final String USER_URL = "user_url";
    private static final String DOC_URL = "doc_url";
    private static final String DSMID = "dsmId";
    private static final String TITLE = "title";

    private String userUrl, docUrl;
    private int dsmId;
    private String title;

    public CustomAttachModifyTime() {
        super(CustomAttachmentType.MODIFY_TIME);
    }

    public CustomAttachModifyTime(H5JsBean.H5JsCmd.Params params) {
        this();
        this.userUrl = params.getUser_url();
        this.docUrl = params.getDoc_url();
        this.dsmId = params.getDsmId();
        this.title = params.getTitle();
    }

    public CustomAttachModifyTime(String userUrl, String docUrl, int dsmId) {
        this();
        this.userUrl = userUrl;
        this.docUrl = docUrl;
        this.dsmId = dsmId;
    }


    public CustomAttachModifyTime(String userUrl, String docUrl, int dsmId,String title) {
        this();
        this.userUrl = userUrl;
        this.docUrl = docUrl;
        this.dsmId = dsmId;
        this.title = title;
    }

    @Override
    protected void parseData(JSONObject data) {
        userUrl = data.getString(USER_URL);
        docUrl = data.getString(DOC_URL);
        dsmId = data.getInteger(DSMID);
        title = data.getString(TITLE);
    }

    @Override
    protected JSONObject packData() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(USER_URL, userUrl);
        jsonObject.put(DOC_URL, docUrl);
        jsonObject.put(DSMID, dsmId);
        jsonObject.put(TITLE, title);
        return jsonObject;
    }

    public String getUserUrl() {
        return userUrl;
    }

    public String getDocUrl() {
        return docUrl;
    }

    public int getDsmId() {
        return dsmId;
    }

    public String getTitle() {
        return title;
    }
}
