package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * 收款消息拓展
 * Created by harvie on 2017/1/10.
 */

public class CustomAttachReceivedMoney extends CustomAttachment {
    private static final String KEY_TITLE="title";
    private static final String KEY_NUM = "num";
    private static final String KEY_ORPAY = "orPay";
    private static final String ISNEWORDER = "isNewOrder";
    private static final String KEY_ORDERID="orderid";
    private String num = "";//订单金额
    private String title = "";//订单标题题
    private int orPay;//支付状态 0未支付1已支付
    private String orderid = "";//订单id
    private Boolean isNewOrder = false;//是否是新订单

    public CustomAttachReceivedMoney() {
        super(CustomAttachmentType.RECEIVEDMONEY);
    }


    @Override
    protected void parseData(JSONObject data) {
        this.orderid=data.getString(KEY_ORDERID);
        this.title=data.getString(KEY_TITLE);
        this.num=data.getString(KEY_NUM);
        this.orPay=data.getInteger(KEY_ORPAY);
        this.isNewOrder=data.getBoolean(ISNEWORDER);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data=new JSONObject();
        data.put(KEY_ORDERID,orderid);
        data.put(KEY_TITLE,title);
        data.put(KEY_NUM,num);
        data.put(KEY_ORPAY,orPay);
        data.put(ISNEWORDER,isNewOrder);
        return data;
    }

    public String getOrderId() {
        return orderid;
    }

    public int getOrPay() {
        return orPay;
    }
    public String getTitle() {
        return title;
    }

    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setOrPay(int orPay) {
        this.orPay = orPay;
    }

    public void setOrderId(String orderId) {
        this.orderid = orderId;
    }


    public Boolean getNewOrder() {
        return isNewOrder;
    }

    public void setNewOrder(Boolean newOrder) {
        isNewOrder = newOrder;
    }
}
