package com.yidianling.im.session.extension;

import android.text.TextUtils;

import com.alibaba.fastjson.JSONObject;
import com.yidianling.common.tools.LogUtil;

/**
 * Created by wi1ls on 2017/1/10.
 */

public class CustomAttachRedPacket extends CustomAttachment {
    private static final String KEY_POCKET_ID="pocket_id";
    private static final String KEY_TITLE="title";
    private String pocket_id;//红包id
    private String title;//红包标题
    public CustomAttachRedPacket() {
        super(CustomAttachmentType.REDPACKET);
    }

    public CustomAttachRedPacket(String pocket_id, String title) {
        super(CustomAttachmentType.REDPACKET);
        this.pocket_id = pocket_id;
        this.title = title;
    }

    @Override
    protected void parseData(JSONObject data) {
        this.pocket_id=data.getString(KEY_POCKET_ID);
        this.title=data.getString(KEY_TITLE);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data=new JSONObject();
        data.put(KEY_POCKET_ID,pocket_id);
        data.put(KEY_TITLE,title);
        return data;
    }

    public String getPocket_id() {
        return pocket_id;
    }

    public String getTitle() {
        LogUtil.d("repacket title: "+title);
        if (!TextUtils.isEmpty(title)&&title.startsWith("[红包]")){
            title=title.substring("[红包]".length(),title.length());
        }
        return title;
    }
}
