package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * 自定义提醒消息（首次私聊，提醒资金安全）
 * Created by harvie on 2017/1/10.
 */

public class CustomAttachTipMsg extends CustomAttachment {
    private static final String KEY_TITLE="from_content";
    private String from_content = "";//提醒内容
    public CustomAttachTipMsg() {
        super(CustomAttachmentType.TIP_MSG);
    }

    public CustomAttachTipMsg(String from_content) {
        super(CustomAttachmentType.TIP_MSG);
        this.from_content = from_content;
    }

    @Override
    protected void parseData(JSONObject data) {
        this.from_content=data.getString(KEY_TITLE);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data=new JSONObject();
        data.put(KEY_TITLE,from_content);
        return data;
    }

    public String getFrom_content() {
        return from_content;
    }

    public void setFrom_content(String from_content) {
        this.from_content = from_content;
    }
}
