package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

public class CustomAttachmentConfirmOrder extends CustomAttachment {
    private static final String TITLE = "title";//标题
    private static final String STATUS = "status";//状态，1代表已确认，0代表待确认
    private static final String BOOKINGTIME = "bookingTime";///咨询时间
    private static final String SERVICETYPE = "serviceType";//服务方式
    private static final String ORDERID = "orderId";//订单号
    private static final String SERVICEID = "serviceId";//订单号
    private static final String NEWSORDERID = "newsOrderId";//用于跳转新版订单详情
    private static final String URL = "url";//跳转链接


    public String servicetype;
    public String consultDuration;
    public String bookingTime;
    public String title;
    public String productName;
    public String url;
    public String orderId;
    public String newsOrderId;
    public String serviceId;
    public int status;

    CustomAttachmentConfirmOrder() {
        super(CustomAttachmentType.TYPE_CONFIRM_ORDER);
    }


    @Override
    protected void parseData(JSONObject data) {
        this.title = data.getString(TITLE);
        this.status = data.getInteger(STATUS);
        this.bookingTime = data.getString(BOOKINGTIME);
        this.servicetype = data.getString(SERVICETYPE);
        this.orderId = data.getString(ORDERID);
        this.serviceId = data.getString(SERVICEID);
        this.newsOrderId = data.getString(NEWSORDERID);
        this.url = data.getString(URL);

    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(TITLE, title);
        data.put(STATUS, status);
        data.put(BOOKINGTIME, bookingTime);
        data.put(SERVICETYPE, servicetype);
        data.put(ORDERID, orderId);
        data.put(SERVICEID, serviceId);
        data.put(NEWSORDERID, newsOrderId);
        data.put(URL, url);
        return data;
    }
}
