package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * Created by Wi1ls on 2016/11/25;
 */
public class CustomAttachmentEvaluate extends CustomAttachment {
    private static final String KEY_USER_URL="user_url";
    private static final String KEY_DOC_URL="doc_url";
    private static final String KEY_ORDERID="orderid";

    private String user_url;
    private String doc_url;
    private String orderid;

    public CustomAttachmentEvaluate() {
        super(CustomAttachmentType.EVALUATE);
    }

    public CustomAttachmentEvaluate(String user_url, String doc_url, String orderid) {
        super(CustomAttachmentType.EVALUATE);
        this.user_url = user_url;
        this.doc_url = doc_url;
        this.orderid = orderid;
    }

    @Override
    protected void parseData(JSONObject data) {
        this.user_url=data.getString(KEY_USER_URL);
        this.doc_url=data.getString(KEY_DOC_URL);
        this.orderid=data.getString(KEY_ORDERID);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(KEY_USER_URL,user_url);
        data.put(KEY_DOC_URL, doc_url);
        data.put(KEY_ORDERID, orderid);
        return data;
    }

    public String getUser_url() {
        return user_url;
    }

    public String getDoc_url() {
        return doc_url;
    }

    public String getOrderid() {
        return orderid;
    }
}
