package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

public class CustomAttachmentOrderAlreadyDone extends CustomAttachment{

    private String TITLE = "title";//标题
    private String STATUS="status";//状态，1代表已确认，0代表待确认
    private String CONSULTDURATION="consultDuration";//购买时长
    private String SERVICETYPE="serviceType"; //服务方式
    private String ORDERID="orderId";//订单号
    private static final String BOOKINGTIME = "bookingTime";///咨询时间
    private static final String URL = "url";//跳转链接
    private static final String NEWSORDERID = "newsOrderId";//用于跳转新版订单详情
    public String newsOrderId;




    public String title;
    public int status;
    public String consultDuration;
    public String serviceType;
    public String orderId;
    public String bookingTime;
    public String url;


    CustomAttachmentOrderAlreadyDone() {
        super(CustomAttachmentType.TYPE_ORDER_ALREADY_DONE);
    }

    @Override
    protected void parseData(JSONObject data) {
        title = data.getString(TITLE);
        status = data.getInteger(STATUS);
        consultDuration = data.getString(CONSULTDURATION);
        serviceType = data.getString(SERVICETYPE);
        orderId = data.getString(ORDERID);
        this.bookingTime = data.getString(BOOKINGTIME);
        this.url = data.getString(URL);
        this.newsOrderId = data.getString(NEWSORDERID);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(TITLE, title);
        data.put(STATUS, status);
        data.put(CONSULTDURATION, consultDuration);
        data.put(SERVICETYPE, serviceType);
        data.put(ORDERID, orderId);
        data.put(BOOKINGTIME, bookingTime);
        data.put(URL, url);
        data.put(NEWSORDERID, newsOrderId);
        return data;
    }
}
