package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/25
 */
public class CustomAttachmentPhoneCallRedPacket extends CustomAttachment {
    private static final String KEY_TITLE = "title";
    private static final String KEY_MONEY = "moneyMsg";
    private static final String KEY_TYPE_RED_PACKET = "typeMsg";
    private static final String KEY_URL = "url";


    private String title;
    private String moeny;
    private String typeRedPacket;
    private String url;

    public  CustomAttachmentPhoneCallRedPacket() {
        super(CustomAttachmentType.TYPE_PHONE_CALL_RED_PACKET);
    }

    @Override
    protected void parseData(JSONObject data) {
        title = data.getString(KEY_TITLE);
        moeny = data.getString(KEY_MONEY);
        typeRedPacket = data.getString(KEY_TYPE_RED_PACKET);
        url=data.getString(KEY_URL);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(KEY_TITLE, title);
        data.put(KEY_MONEY, moeny);
        data.put(KEY_TYPE_RED_PACKET, typeRedPacket);
        data.put(KEY_URL,url);
        return null;
    }

    public String getTitle() {
        return title;
    }

    public String getMoeny() {
        return moeny;
    }

    public String getTypeRedPacket() {
        return typeRedPacket;
    }

    public String getUrl() {
        return url;
    }
}
