package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * Created by Wi1ls on 2016/12/14;
 */
public class  CustomAttachmentRecommendAssistant extends CustomAttachment{
    private static final String KEY_TOUID="to_uid";
    private static final String KEY_IMG="img";
    private static final String KEY_NAME="name";
    private static final String KEY_USER_TYPE="user_type";
    private static final String KEY_TITLE="title";

    private String to_uid;//userType=1,表示助手uid;type=2表示用户uid
    private String img;//头像
    private String name;//用户名
    private String user_type;//1发送给用户,2发送给助手
    private String title;//用以消息列表展示

    public CustomAttachmentRecommendAssistant() {
        super(CustomAttachmentType.ASSISTANT);
    }

    @Override
    protected void parseData(JSONObject data) {
        to_uid=data.getString(KEY_TOUID);
        img=data.getString(KEY_IMG);
        name=data.getString(KEY_NAME);
        user_type=data.getString(KEY_USER_TYPE);
        title=data.getString(KEY_TITLE);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(KEY_TOUID,to_uid);
        data.put(KEY_IMG,img);
        data.put(KEY_NAME,name);
        data.put(KEY_USER_TYPE,user_type);
        data.put(KEY_TITLE,title);
        return data;
    }

    public String getTouid() {
        return to_uid;
    }

    public String getImg() {
        return img;
    }

    public String getName() {
        return name;
    }

    public String getUser_type() {
        return user_type;
    }

    public String getTitle() {
        return title;
    }
}
