package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * Created by Wi1ls on 2016/11/9;
 */
public class CustomAttachmentTest extends CustomAttachment {
    public static final int FLAG_TESTING=1;
    public static final int FLAG_RESULT=2;

    private static final String KEY_FLAG="flag";
    private static final String KEY_TITLE="title";
    private static final String KEY_IMG="img";
    private static final String KEY_URL="url";
    private static final String KEY_ID="id";
    private static final String KEY_SHARE_URL="share_url";

    private int flag;
    private String title;
    private String img;
    private String url;
    private int id;
    private String share_url;


    public CustomAttachmentTest() {
        super(CustomAttachmentType.TEST);
    }

    public CustomAttachmentTest(int flag,String title, String img, String url, int id,String share_url) {
        super(CustomAttachmentType.TEST);
        this.flag=flag;
        this.title = title;
        this.img = img;
        this.url = url;
        this.id = id;
        this.share_url=share_url;
    }

    @Override
    protected void parseData(JSONObject data) {
        this.flag=data.getInteger(KEY_FLAG);
        this.title=data.getString(KEY_TITLE);
        this.img=data.getString(KEY_IMG);
        this.url=data.getString(KEY_URL);
        this.id=data.getInteger(KEY_ID);
        this.share_url=data.getString(KEY_SHARE_URL);
    }

    @Override
    protected JSONObject packData() {

        JSONObject data = new JSONObject();
        data.put(KEY_FLAG,flag);
        data.put(KEY_TITLE, title);
        data.put(KEY_IMG, img);
        data.put(KEY_URL, url);
        data.put(KEY_ID, id);
        data.put(KEY_SHARE_URL,share_url);
        return data;
    }

    public String getTitle() {
        return title;
    }

    public String getImg() {
        return img;
    }

    public String getUrl() {
        return url;
    }

    public int getId() {
        return id;
    }

    public int getFlag() {
        return flag;
    }

    public String getShare_url() {
        return share_url;
    }
}
