package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * Created by xj 后端发送的系统消息
 */
public class CustomSystemTips extends CustomAttachment {

    private String to_content;
    private int hidden_app;


    public CustomSystemTips() {
        super(CustomAttachmentType.TYPE_CUSTOM_SYSTEM_TIPS);
    }

    @Override
    protected void parseData(JSONObject data) {
        to_content = data.getString("to_content");
        hidden_app = data.getIntValue("hidden_app");
    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        try {
            data.put("to_content", to_content);
            data.put("hidden_app", hidden_app);
        } catch (Exception ignored) {
        }
        return data;
    }

    public String getToContent() {
        return to_content;
    }

    public int getHiddenApp() {
        return hidden_app;
    }
}
