package com.yidianling.im.session.viewholder;

import android.graphics.Color;
import android.widget.ImageView;
import android.widget.TextView;

import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.netease.nimlib.sdk.avchat.constant.AVChatType;
import com.netease.nimlib.sdk.avchat.model.AVChatAttachment;
import com.yidianling.im.R;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.nimbase.common.util.sys.TimeUtil;

/**
 * Created by zhoujianghua on 2015/8/6.
 */
public class MsgViewHolderAVChat extends MsgViewHolderBase {

    private ImageView typeImage;
    private TextView statusLabel;

    public MsgViewHolderAVChat(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_nim_message_item_avchat;
    }

    @Override
    protected void inflateContentView() {
        typeImage = findViewById(R.id.message_item_avchat_type_img);
        statusLabel = findViewById(R.id.message_item_avchat_state);
    }

    @Override
    protected void bindContentView() {
        if (message.getAttachment() == null) {
            return;
        }

        layoutByDirection();

        refreshContent();
    }

    private void layoutByDirection() {
        AVChatAttachment attachment = (AVChatAttachment) message.getAttachment();

        if (isReceivedMessage()) {
            if (attachment.getType() == AVChatType.AUDIO) {
                typeImage.setImageResource(R.drawable.im_avchat_left_type_audio);
            } else {
                typeImage.setImageResource(R.drawable.im_avchat_left_type_video);
            }
            statusLabel.setTextColor(context.getResources().getColor(R.color.platform_color_grey_999999));
        } else {
            if (attachment.getType() == AVChatType.AUDIO) {
                typeImage.setImageResource(R.drawable.im_avchat_right_type_audio);
            } else {
                typeImage.setImageResource(R.drawable.im_avchat_right_type_video);
            }
            statusLabel.setTextColor(Color.WHITE);
        }
    }

    private void refreshContent() {
        AVChatAttachment attachment = (AVChatAttachment) message.getAttachment();

        String textString = "";
        switch (attachment.getState()) {
        case Success: //成功接听
            textString = "通话接听时长 " + TimeUtil.secToTime(attachment.getDuration());
            break;
        case Missed: //未接听
        case Rejected: //主动拒绝
            textString = context.getString(R.string.im_avchat_no_pick_up);
            break;
        default:
            break;
        }

        statusLabel.setText(textString);
    }
}
