package com.yidianling.im.session.viewholder;

import android.widget.TextView;

import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachConsult;
import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;

/**
 * Created by Wi1ls on 2016/11/28;
 */
public class MsgViewHolderConsult extends MsgViewHolderBase {
    private String url;
    private String title;

    private TextView tv_title;
    private TextView tv_flag;
    private TextView check;

    public MsgViewHolderConsult(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_p2p_evaluate;
    }

    @Override
    protected void inflateContentView() {
        tv_title= (TextView) view.findViewById(R.id.evaluate_title);
        tv_flag= (TextView) view.findViewById(R.id.tv_flag);
        check= (TextView) view.findViewById(R.id.check);
    }

    @Override
    protected void bindContentView() {
        CustomAttachConsult customAttachConsult= (CustomAttachConsult) message.getAttachment();
        url=customAttachConsult.getUrl();
        title=customAttachConsult.getTitle();
        tv_title.setText(title);
        tv_flag.setText("咨询介绍");
    }

    @Override
    protected void onItemClick() {
        NewH5Activity.start(view.getContext(),new H5Params(url,null));
    }
}
