package com.yidianling.im.session.viewholder;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.ydl.audioim.api.IAudioImService;
import com.ydl.ydlcommon.modular.ModularServiceManagerKt;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachConsultCallStatus;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;

/**
 * Created by zhoujianghua on 2015/8/6.
 */
public class MsgViewHolderConsultCallStatus extends MsgViewHolderBase {

    private ImageView typeImageLeft;
    private ImageView typeImageRight;
    private TextView statusLabel;
    private View lineView;
    private TextView btnView;

    public MsgViewHolderConsultCallStatus(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_custom_consult_call_status;
    }

    @Override
    protected void inflateContentView() {
        typeImageLeft = findViewById(R.id.message_item_type_img_left);
        typeImageRight = findViewById(R.id.message_item_type_img_right);
        statusLabel = findViewById(R.id.message_item_avchat_state);
        lineView = findViewById(R.id.message_item_avchat_line);
        btnView = findViewById(R.id.message_item_avchat_btn);
    }

    @Override
    protected void bindContentView() {
        CustomAttachConsultCallStatus customAttachTipMsg = (CustomAttachConsultCallStatus) message.getAttachment();
        layoutByDirection(customAttachTipMsg);

    }

    private void layoutByDirection(CustomAttachConsultCallStatus customAttachTipMsg) {

        if (isReceivedMessage()) {
            typeImageLeft.setVisibility(View.VISIBLE);
            typeImageRight.setVisibility(View.GONE);
        } else {
            typeImageLeft.setVisibility(View.GONE);
            typeImageRight.setVisibility(View.VISIBLE);
        }


        if (isReceivedMessage()) {
            statusLabel.setText(customAttachTipMsg.getCallee());
        } else {
            statusLabel.setText(customAttachTipMsg.getCaller());
        }
        long messageTime = message.getTime();
        boolean isExpired =  System.currentTimeMillis() - messageTime > 60 * 1000;
        Integer pullCall = customAttachTipMsg.getPullCall();
        if (!isExpired && pullCall != null && pullCall == 1 && isReceivedMessage()) {
            lineView.setVisibility(View.VISIBLE);
            btnView.setVisibility(View.VISIBLE);
            btnView.setOnClickListener(v -> {
                String sessionId = message.getSessionId();
                ModularServiceManagerKt.findRouteService(IAudioImService.class)
                        .callCheck(v.getContext(), sessionId, 0);
            });
        } else {
            lineView.setVisibility(View.GONE);
            btnView.setVisibility(View.GONE);
        }
    }

    @Override
    protected int leftBackground() {
        CustomAttachConsultCallStatus customAttachTipMsg = (CustomAttachConsultCallStatus) message.getAttachment();
        if (!"true".equals(customAttachTipMsg.getIsConsultOrder())) {
            return R.drawable.im_message_receive_content_tip_bg;
        } else {
            return R.drawable.im_message_receive_content_bg;
        }
    }

    @Override
    protected int rightBackground() {
        CustomAttachConsultCallStatus customAttachTipMsg = (CustomAttachConsultCallStatus) message.getAttachment();
        if (!"true".equals(customAttachTipMsg.getIsConsultOrder())) {
            return R.drawable.im_message_send_content_tip_bg;
        } else {
            return R.drawable.im_message_send_content_bg;
        }
    }
}
