package com.yidianling.im.session.viewholder;

import androidx.appcompat.app.AppCompatActivity;
import android.widget.LinearLayout;

import com.yidianling.im.R;
import com.yidianling.im.helper.IMChatUtil;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;

/**
 * Created by xj on 2019/10/29.
 */

public class MsgViewHolderCustomerServiceCard extends MsgViewHolderBase {

    private LinearLayout customer_service_card_bg;

    public MsgViewHolderCustomerServiceCard(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_customer_serice;
    }

    @Override
    protected void inflateContentView() {
        customer_service_card_bg = view.findViewById(R.id.customer_service_card_bg);
    }

    @Override
    protected void bindContentView() {
        hideItemBg();

        if (isReceivedMessage()) {
            customer_service_card_bg.setBackgroundResource(R.drawable.im_customer_service_card_receive_bg);
        }else {
            customer_service_card_bg.setBackgroundResource(R.drawable.im_customer_service_card_send_bg);
        }
    }

    @Override
    protected void onItemClick() {
        super.onItemClick();
        IMChatUtil.INSTANCE.startKefuChat((AppCompatActivity) context);
    }
}
