package com.yidianling.im.session.viewholder;


import android.view.View;
import android.widget.TextView;

import com.yidianling.im.R;
import com.yidianling.im.helper.SpanUtils;
import com.yidianling.im.session.extension.CustomAttachLingxiAnswerQuestion;
import com.yidianling.im.session.viewholder.bean.QuestionItemBean;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;

import java.util.ArrayList;

public class MsgViewHolderLingxiAnswerQuestion extends MsgViewHolderBase {
    private TextView answer_question;
    CustomAttachLingxiAnswerQuestion customattachLingxiAnswerQuestion;
    private ArrayList<QuestionItemBean> itemBeans;
    private StringBuffer sb;
    private boolean isContainsOther=false;
    private String others;
    public MsgViewHolderLingxiAnswerQuestion(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
       return  R.layout.im_nim_lingxi_answer_question;
    }

    @Override
    protected void inflateContentView() {
        answer_question = findViewById(R.id.answer_question);

    }

    @Override
    protected boolean isReceivedMessage() {
        return false;
    }


    @Override
    protected void bindContentView() {
        avatarLeft.setVisibility(View.INVISIBLE);
        customattachLingxiAnswerQuestion = ((CustomAttachLingxiAnswerQuestion) message.getAttachment());
        itemBeans=customattachLingxiAnswerQuestion.answers;
        sb=new StringBuffer();
        for (int j=0;j<itemBeans.size();j++){
            if (itemBeans.get(j).getOther()!=null){
                if (itemBeans.get(j).getOther().trim().length()>0){
                    others= itemBeans.get(j).getOther();
                    isContainsOther=true;
                    break;
                }
            }
        }
        for (int i=0;i<itemBeans.size();i++){
            if (isContainsOther){
                sb.append("#"+itemBeans.get(i).getName()+"  ");
            }else{
                sb.append("、"+itemBeans.get(i).getName()+"  ");
            }
        }
        if (itemBeans.size()==1&&!itemBeans.get(0).getName().contains("其他")){
            answer_question.setText(itemBeans.get(0).getName());
        }else{
            if (!isContainsOther){
                sb.replace(0,1,"");
            }
            if (others==null){
                answer_question.setText(sb.toString());
            }else{
                SpanUtils.with(answer_question).append(sb).append("\r\n\r\n").setFontSize(15).append(others).create();
            }
        }
    }
}
