package com.yidianling.im.session.viewholder;

import android.widget.TextView;

import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.netease.nimlib.sdk.msg.attachment.MsgAttachment;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachmentPhoneCallRedPacket;
import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;

/**
 * @author jiucheng
 * @描述: 倾述完成后，评价领取红包
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/25
 */
public class MsgViewHolderPhoneCallRedPacket extends MsgViewHolderBase {

    private TextView titleTv;
    private TextView moneyTv;
    private TextView typeTv;
    private String url;
    private String title;
    private String money;
    private String type;

    public MsgViewHolderPhoneCallRedPacket(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_phone_call_red_packet;
    }

    @Override
    protected void inflateContentView() {
        titleTv = view.findViewById(R.id.tv_title);
        moneyTv = view.findViewById(R.id.tv_money);
        typeTv = view.findViewById(R.id.tv_type);
    }

    @Override
    protected void bindContentView() {
        MsgAttachment attachment = message.getAttachment();
        if (attachment instanceof CustomAttachmentPhoneCallRedPacket) {
            url = ((CustomAttachmentPhoneCallRedPacket) attachment).getUrl();
            money = ((CustomAttachmentPhoneCallRedPacket) attachment).getMoeny();
            title = ((CustomAttachmentPhoneCallRedPacket) attachment).getTitle();
            type = ((CustomAttachmentPhoneCallRedPacket) attachment).getTypeRedPacket();
            titleTv.setText(title);
            moneyTv.setText(money);
            typeTv.setText(type);
        }
    }

    @Override
    protected void onItemClick() {
        NewH5Activity.start(context, new H5Params(url, "评价"));
    }
}
