package com.yidianling.im.session.viewholder;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;
import com.ydl.ydlcommon.base.config.HttpConfig;
import com.yidianling.im.R;
import com.yidianling.im.config.constants.ImConstants;
import com.yidianling.im.session.extension.CustomAttachReceivedMoney;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;


/**
 * 收款消息拓展
 * Created by wi1ls on 2017/1/10.
 */

public class MsgViewHolderReceivedMoney extends MsgViewHolderBase {

    private String num;//订单金额
    private String title;//订单标题题
    private int orPay;//支付状态 0未支付1已支付
    private String orderid;//订单id
    private Boolean isNewOrder;//是否是新订单

    private View message_received;
    private TextView tit, content;
    private ImageView img;

    public MsgViewHolderReceivedMoney(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }


    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_received_money;
    }

    @Override
    protected void inflateContentView() {
        message_received = findViewById(R.id.message_received);
        tit = findViewById(R.id.packet_title);
        content = findViewById(R.id.text_content);
        img = findViewById(R.id.packte_im);
    }

    @Override
    protected void bindContentView() {
        CustomAttachReceivedMoney customAttachReceivedMoney = (CustomAttachReceivedMoney) message.getAttachment();
        orderid = customAttachReceivedMoney.getOrderId();
        num = customAttachReceivedMoney.getNum();
        title = customAttachReceivedMoney.getTitle();
        orPay = customAttachReceivedMoney.getOrPay();
        num = customAttachReceivedMoney.getNum();
        isNewOrder = customAttachReceivedMoney.getNewOrder();

        if (title != null) {
            tit.setText(title);
        }
        if (orPay == 1) {
            //支付成功
            if (num != null) {
                content.setText("您支付了" + num + "元");
            }
            img.setImageDrawable(view.getResources().getDrawable(R.mipmap.im_zhifu));
        } else {
            if (num != null) {
                content.setText("您需要支付" + num + "元");
            }
            img.setImageDrawable(view.getResources().getDrawable(R.mipmap.im_weifu));
        }

        hideItemBg();
    }

    @Override
    protected void onItemClick() {
        if (isReceivedMessage()) {
            if (isNewOrder != null && isNewOrder) {
                H5Params orderParams = new H5Params(
                        ImConstants.Companion.getPAY_DETAIL() + (orderid.isEmpty() ? "" : orderid), null);
                NewH5Activity.start(context, orderParams);
            } else {
                NewH5Activity.start(view.getContext(), new H5Params(HttpConfig.Companion.getH5_URL() + "receipt/order?oid=" + orderid, null));
            }
        }
    }

}
