package com.yidianling.im.session.viewholder;

import android.app.Activity;
import android.view.View;
import android.widget.TextView;

import com.ydl.ydlcommon.data.http.RxUtils;
import com.ydl.ydlcommon.utils.NetworkParamsUtils;
import com.ydl.ydlcommon.utils.UserInfoCache;
import com.ydl.ydlcommon.utils.remind.HttpErrorUtils;
import com.yidianling.common.tools.LogUtil;
import com.yidianling.im.R;
import com.yidianling.im.bean.RedPacketDetailBean;
import com.yidianling.im.bean.RedPacketDetailCmd;
import com.yidianling.im.http.ImRetrofitApi;
import com.yidianling.im.router.ImIn;
import com.yidianling.im.session.extension.CustomAttachRedPacket;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.im.api.bean.ReceiveRedPacketParam;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.yidianling.user.api.bean.UserResponseBean;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

/**
 * Created by wi1ls on 2017/1/10.
 */

public class MsgViewHolderRedPacket extends MsgViewHolderBase {

    private String pocket_id;
    private String title;

    private View message_red_packet;

    public MsgViewHolderRedPacket(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }


    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_red_packet;
    }

    @Override
    protected void inflateContentView() {
        message_red_packet = findViewById(R.id.message_red_packet);
    }

    @Override
    protected void bindContentView() {
        CustomAttachRedPacket customAttachRedPacket = (CustomAttachRedPacket) message.getAttachment();
        pocket_id = customAttachRedPacket.getPocket_id();
        title = customAttachRedPacket.getTitle();
        LogUtil.d("get title: "+title);
        ((TextView) message_red_packet.findViewById(R.id.packet_title)).setText(title);
        hideItemBg();
    }

    @Override
    protected void onItemClick() {
        RedPacketDetailCmd cmd = new RedPacketDetailCmd(pocket_id);
        ImRetrofitApi.Companion.getImRetrofitApi().redPacketDetail(NetworkParamsUtils.getMaps(cmd))
                .subscribeOn(Schedulers.io())
                .compose(RxUtils.INSTANCE.resultData())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(resp -> {
                    RedPacketDetailBean data = resp;

                    UserInfoCache.YDLUser user = UserInfoCache.getInstance().getUser(data.to_uid);
                    if ((ImIn.INSTANCE.getUserInfo().getUid() + "").equals(data.uid)) {

                        UserResponseBean.UserInfo userInfo = ImIn.INSTANCE.getUserInfo();
                        ReceiveRedPacketParam param = new ReceiveRedPacketParam(
                                data.status,
                                data.money,
                                userInfo.getNick_name(),
                                userInfo.getHead(),
                                user.getAvatar(),
                                user.getNickName(),
                                data.get_time
                        );

                        ImIn.INSTANCE.receiveRedPacketIntent((Activity) context, param);

                    }
                }, throwable -> HttpErrorUtils.Companion.handleError(context, throwable));

    }

    //打开已经被领取的红包
    private void openHasOpened() {

    }

    //打开未被领取的红包
    private void openUnOpened() {

    }
}
