package com.yidianling.im.session.viewholder

import android.annotation.SuppressLint
import android.widget.TextView
import com.ydl.confide.api.ConfideRoute.R_CONFIDE_HOME
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.modular.route
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.ydl.ydlcommon.utils.Utils
import com.ydl.ydlcommon.utils.remind.HttpErrorUtils.Companion.handleError
import com.yidianling.common.tools.ToastUtil
import com.yidianling.im.R
import com.yidianling.im.bean.PushConfideStatusBean
import com.yidianling.im.http.ImRetrofitApi.Companion.getImJavaApi
import com.yidianling.im.router.ImIn.getUserResponse
import com.yidianling.im.session.extension.CustomAttachmentShareMsg
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.Disposable
import io.reactivex.schedulers.Schedulers

/**
 * Created by haorui on 2019-11-06 .
 * Des: 分享 消息
 * 分享的类型，0：测试；1，课程；2，文章；3：倾诉
 * 消息由咨询师端触发
 */
class MsgViewHolderShareMsg(adapter: BaseMultiItemFetchLoadAdapter<*, *>?) :
    MsgViewHolderBase(adapter) {
    private var tv_confide_money: TextView? = null
    private var tv_confide: TextView? = null
    var mShareUrl: String? = null
    var mPrice: String? = null
    private var mShareType = 0
    private var mSubscribe: Disposable? = null
    private var mConfidedId: String? = null
    private var mDoctorId: String? = null

    //测试
    val Type0 = 0

    //课程
    private val Type1 = 1

    //文章
    private val Type2 = 2

    //倾诉
    private val Type3 = 3
    private val SUCCESS_CODE = "200"
    override fun getContentResId(): Int {
        val attachment = message.attachment
        if (attachment is CustomAttachmentShareMsg) {
            return when (attachment.shareType) {
                Type0 -> R.layout.im_ui_message_custom_confide
                Type1 -> R.layout.im_ui_message_custom_confide
                Type2 -> R.layout.im_ui_message_custom_confide
                Type3 -> R.layout.im_ui_message_custom_confide
                else -> R.layout.im_ui_message_custom_confide
            }
        }
        return R.layout.im_ui_message_custom_confide
    }

    override fun inflateContentView() {
        tv_confide_money = view.findViewById(R.id.tv_confide_money)
        tv_confide = view.findViewById(R.id.tv_confide)
    }

    override fun bindContentView() {
        val attachment = message.attachment
        if (attachment is CustomAttachmentShareMsg) {
            mShareUrl = attachment.shareUrl
            mPrice = attachment.sharePrice
            mShareType = attachment.shareType
            mConfidedId = attachment.confidedId
            mDoctorId = attachment.doctorId
        }
        if (isReceivedMessage) {
            setAvatarRightInVisibity()
        } else {
            setAvatarLeftInVisibity()
        }
        when (mShareType) {
            Type0 -> {
            }
            Type1 -> {
            }
            Type2 -> {
            }
            Type3 -> tv_confide_money!!.text = mPrice
            else -> {
            }
        }
    }

    override fun onItemClick() {
        super.onItemClick()
        if (Utils.isFastClick()) {
            //防止连击
            return
        }
        requestConfideStatus()
    }

    @SuppressLint("CheckResult")
    private fun requestConfideStatus() {
        if (mSubscribe != null && !mSubscribe!!.isDisposed) {
            mSubscribe!!.dispose()
        }
        val userInfo = getUserResponse()
        mSubscribe = getImJavaApi().getPushConfideStatus(userInfo!!.uid!!, message.fromAccount)
            .subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(
            { it: BaseAPIResponse<PushConfideStatusBean> ->
                if (SUCCESS_CODE == it.code) {
                    val data = it.data
                    if (data.isOpen != 1) {
                        ToastUtil.toastShort(view.context.getString(R.string.im_push_confide_msg_unopened))
                        return@subscribe
                    }
                    if (data.isOnline != 1) {
                        ToastUtil.toastShort(view.context.getString(R.string.im_push_confide_msg_offline))
                        return@subscribe
                    }
                    if (data.isReducible != 1) {
                        ToastUtil.toastShort(view.context.getString(R.string.im_push_confide_msg_busy))
                        return@subscribe
                    }
                    if (data.isStatus != 1) {
                        ToastUtil.toastShort(view.context.getString(R.string.im_push_confide_msg_calling))
                        return@subscribe
                    }
                    if (mShareType == Type3 && mConfidedId != null && mDoctorId != null) {

                        //新版本走倾诉列表逻辑
                        route(view.context, R_CONFIDE_HOME,
                            IYDLRouterConstant.EXTRA_CONFIDEDID to mConfidedId,
                            IYDLRouterConstant.EXTRA_DOCTORID to mDoctorId)

                    } else {
                        //老版本去专家主页
                        NewH5Activity.start(view.context, H5Params(mShareUrl!!, null))
                    }
                }
            }) { t: Throwable? -> handleError(context, t!!) }
    }
}