package com.yidianling.im.session.viewholder;

import android.widget.ImageView;

import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderThumbBase;
import com.ydl.ydl_image.module.GlideApp;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.StickerAttachment;
import com.yidianling.nimbase.business.session.emoji.StickerManager;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;


/**
 * Created by zhoujianghua on 2015/8/7.
 */
public class MsgViewHolderSticker extends MsgViewHolderBase {

    private ImageView baseView;

    public MsgViewHolderSticker(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_nim_message_item_sticker;
    }

    @Override
    protected void inflateContentView() {
        baseView = findViewById(R.id.message_item_sticker_image);
        baseView.setMaxWidth(MsgViewHolderThumbBase.getImageMaxEdge());
    }

    @Override
    protected void bindContentView() {
        StickerAttachment attachment = (StickerAttachment) message.getAttachment();
        if (attachment == null) {
            return;
        }

        GlideApp.with(context)
                .load(StickerManager.getInstance().getStickerUri(attachment.getCatalog(), attachment.getChartlet()))
                .error(R.drawable.im_nim_default_img_failed)
//                .diskCacheStrategy(DiskCacheStrategy.NONE)
                .into(baseView);
    }

    @Override
    protected int leftBackground() {
        return 0;
    }

    @Override
    protected int rightBackground() {
        return 0;
    }
}
