package com.yidianling.im.session.viewholder;

import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;


import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomSystemTips;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;

/**
 * @author xj
 * @描述: 后台的系统自定义消息
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/07/17
 */
public class MsgViewHolderSystemTips extends MsgViewHolderBase {

    private TextView tpisTv;

    public MsgViewHolderSystemTips(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_custom_system_tips;
    }

    @Override
    protected void inflateContentView() {
        tpisTv = view.findViewById(R.id.tv_content);
    }

    @Override
    protected void bindContentView() {
        String text = "请下载新版本查看";
        CustomSystemTips customSystemTips= (CustomSystemTips) message.getAttachment();
        if (!TextUtils.isEmpty(customSystemTips.getToContent())
                && customSystemTips.getHiddenApp() != 1
                && customSystemTips.getHiddenApp() != 3){
            tpisTv.setText(text);
        }else {
            tpisTv.setVisibility(View.GONE);
        }

        hideHead();
        hideItemBg();
    }

    @Override
    protected void onItemClick() {
    }
}
