package com.yidianling.im.session.viewholder.adapter

import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.core.content.ContextCompat
import com.yidianling.im.R
import com.yidianling.im.session.viewholder.bean.LingxiWhichQuestionBean
import com.yidianling.im.session.viewholder.bean.QuestionItemBean

/**
 * @author huozhiliang
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2021/6/21
 */
class AdapterLingxiMultipleChoice : RecyclerView.Adapter<AdapterLingxiMultipleChoice.ViewHolder>() {
    private lateinit var tagList: List<QuestionItemBean>
    private var onItemClickListener: OnMultiplelItemClickListener? = null

    class ViewHolder(itemView: View) :
        RecyclerView.ViewHolder(itemView) {
        val tvWhichQuestion: TextView = itemView.findViewById(R.id.tv_which_question)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(
            LayoutInflater.from(parent.context).inflate(
                R.layout.im_lingxi_which_question_item,
                parent,
                false
            )
        )
    }

    override fun getItemCount(): Int {
        return tagList.size ?: 0
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.tvWhichQuestion.text=tagList[position].name
        holder.tvWhichQuestion.setOnClickListener {
            onItemClickListener?.onMultipleItemClick(
                tagList[position], position
            )
        }
        if (tagList[position].isSelected!!){
            holder.tvWhichQuestion.background= ContextCompat.getDrawable(holder.itemView.context,R.drawable.im_background_18dp_1da1f2)
            holder.tvWhichQuestion.setTextColor(ContextCompat.getColor(holder.itemView.context,R.color.white))
        }else{
            holder.tvWhichQuestion.background= ContextCompat.getDrawable(holder.itemView.context,R.drawable.im_background_18dp_e8f5fe)
            holder.tvWhichQuestion.setTextColor(ContextCompat.getColor(holder.itemView.context,R.color.platform_color_1DA1F2))
        }
    }

    fun setTagData(data: List<QuestionItemBean>) {
        tagList = data
        notifyDataSetChanged()
    }

    interface OnMultiplelItemClickListener {
        fun onMultipleItemClick(string: QuestionItemBean, position: Int)
    }
    fun setItemListener(listener: OnMultiplelItemClickListener) {
        this.onItemClickListener = listener
    }
}