package com.yidianling.im.ui.page.dialog

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.WindowManager
import com.yidianling.im.R
import kotlinx.android.synthetic.main.im_message_chat_setting.*

/**
 * Created by xj on 2019/10/14.
 */
class MessageChatSettingDialog(context: Context, private var listener: OnMessageChatSettingDialog?): Dialog(context, R.style.dialog_default_style) {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.im_message_chat_setting)

        val params = window.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.MATCH_PARENT
        window.attributes = params

        cancel_btn.setOnClickListener {
            listener?.onCancel()
        }
        sure_btn.setOnClickListener {
            listener?.onSure()
        }

    }

    interface OnMessageChatSettingDialog {
        fun onCancel()
        fun onSure()
    }


}