package com.yidianling.im.ui.page.fragment.view

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.RelativeLayout
import com.yidianling.im.R
import com.yidianling.im.ui.page.fragment.bean.InteractItemBean
import kotlinx.android.synthetic.main.im_interact_item_view.view.*

/**
 * 互动列表普通itemView
 */
class InteractItemView(mContext: Context): LinearLayout(mContext) {

    init {
        val params = LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = params
        View.inflate(mContext, R.layout.im_interact_item_view, this)
    }

    fun initData(bean: InteractItemBean?) {
        bean?.let {
            interact_item_title.text = bean.typeTitle
            interact_item_desc.text = bean.content

            // isRead 1未读 0 已读
            if (bean.isRead == 1) {
                interact_has_unread.visibility = View.VISIBLE
            }else {
                interact_has_unread.visibility = View.GONE
            }
        }
    }

}