package com.yidianling.im.ui.page.fragment.view

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.RelativeLayout
import com.ydl.ydl_image.module.GlideApp
import com.yidianling.im.R
import com.yidianling.im.ui.page.fragment.bean.NoticeItemBean
import kotlinx.android.synthetic.main.im_notice_item_view.view.*

/**
 * 互动列表普通itemView
 */
class NoticeItemView(mContext: Context): LinearLayout(mContext) {

    init {
        val params = RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = params
        View.inflate(mContext, R.layout.im_notice_item_view, this)
    }

    fun initData(bean: NoticeItemBean?) {
        bean?.let {
            GlideApp.with(context)
                    .load(bean.head)
                    .circleCrop()
                    .into(notice_message_img)
            notice_message_title.text = bean.title
            notice_message_content.text = bean.content

            if (bean.num > 0) {
                //未读数
                notice_message_unread_num.text = "${bean.num}"
                notice_message_unread_num.visibility = View.VISIBLE
            }else {
                notice_message_unread_num.visibility = View.GONE
            }

        }
    }

}