package com.yidianling.im.ui.page.popupWindow

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import android.widget.PopupWindow
import com.yidianling.im.R
import kotlinx.android.synthetic.main.im_chat_setting_popup_window.view.*


/**
 * Created by xj on 2019/10/14.
 */
class ChatSettingPopupWindow(context: Context, chatSettingClickListener: OnChatSettingClickListener?) : PopupWindow(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT) {
    init {
        val view = LayoutInflater.from(context).inflate(R.layout.im_chat_setting_popup_window, null)
        this.contentView = view
        this.isFocusable = true
        this.isOutsideTouchable = true
        view.ll_all_read.setOnClickListener {
            chatSettingClickListener?.onAllReadClick()
            dismiss()
        }
        view.ll_chat_setting.setOnClickListener {
            chatSettingClickListener?.onChatSettingClick()
            dismiss()
        }
        view.ll_safeinfo_setting.setOnClickListener {
            chatSettingClickListener?.onSafeInfoSetting()
            dismiss()
        }
        setOnDismissListener {
            chatSettingClickListener?.onDismissAction()
        }
    }

    interface OnChatSettingClickListener {
        fun onAllReadClick() //全部已读
        fun onChatSettingClick() //消息设置
        fun onSafeInfoSetting() //隐私设置
        fun onDismissAction() //隐私设置
    }
}