package com.yidianling.im.ui.page.widget

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.widget.LinearLayout
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.yidianling.consultant.api.IConsultantService
import com.yidianling.dynamic.api.IDynamicService
import com.yidianling.im.R
import kotlinx.android.synthetic.main.im_chat_unusual_view.view.*

/**
 * Created by xj on 2019/10/14.
 */
class ChatUnusualView constructor(private val mContext: Context, attrs: AttributeSet? = null) : LinearLayout(mContext, attrs) {

    companion object {
        const val TYPE_UNLOGIN = 100001 // 未登录
        const val TYPE_CHAT_ALL_NO_DATA = 100002 // 没有私聊数据(全部)
        const val TYPE_CHAT_SERVICING_NO_DATA = 100003 // 没有私聊数据(服务中)
        const val TYPE_CHAT_SERVICED_NO_DATA = 100004 // 没有私聊数据(服务过)
        const val TYPE_NOTIFICATION_NO_DATA = 100005 // 没有通知数据
        const val TYPE_INTERACT_NO_DATA = 100006 // 没有互动数据
    }

    var mListener: ChatUnusualListener? = null


    fun setListener(listener: ChatUnusualListener) {
        mListener = listener
    }

    init {
        initView()
    }

    private fun initView() {
        View.inflate(mContext, R.layout.im_chat_unusual_view, this)
    }

    /**
     * 设置页面类型
     */
    fun setUnusualType(type: Int) {
        when (type) {
        // 私聊未登录
            TYPE_UNLOGIN -> {
                unusual_txt.text = "登录后查看全部消息"
                unusual_btn.text = "现在登录"
                unusual_btn.visibility = View.VISIBLE
                unusual_img.setImageResource(R.mipmap.im_default_siliao)
            }
        // 没有私聊数据(全部)
            TYPE_CHAT_ALL_NO_DATA -> {
                unusual_txt.text = "主动私聊更容易遇到懂你的咨询师哦！"
                unusual_btn.text = "去咨询"
                unusual_btn.visibility = View.VISIBLE
                unusual_img.setImageResource(R.mipmap.im_default_siliao_none)
            }
        // 没有私聊数据(服务中)
            TYPE_CHAT_SERVICING_NO_DATA -> {
                unusual_txt.text = "当前没有正在为您服务的咨询师"
                unusual_btn.text = "去咨询"
                unusual_btn.visibility = View.VISIBLE
                unusual_img.setImageResource(R.mipmap.im_default_siliao_none)
            }
        // 没有私聊数据(服务过)
            TYPE_CHAT_SERVICED_NO_DATA -> {
                unusual_txt.text = "暂时没有为您服务过的咨询师"
                unusual_btn.text = "去咨询"
                unusual_btn.visibility = View.VISIBLE
                unusual_img.setImageResource(R.mipmap.im_default_siliao_none)
            }
        // 没有通知数据
            TYPE_NOTIFICATION_NO_DATA -> {
                unusual_txt.text = "暂未收到通知"
                unusual_btn.visibility = View.GONE
                unusual_img.setImageResource(R.mipmap.im_default_tongzhi)
            }
        // 没有互动数据
            TYPE_INTERACT_NO_DATA -> {
                var unusualTxtStr = "这里好安静，先逛逛社区和大家互动一下吧"
                var unusualBtnStr = "去「问答」逛逛"
                if (!ModularServiceManager.isDependByClz(IDynamicService::class.java)){
                    if (ModularServiceManager.isDependByClz(IConsultantService::class.java)){
                        unusualTxtStr = "这里好安静，先找咨询师聊一下吧"
                        unusualBtnStr = "去「咨询」逛逛"
                    }
                }
                unusual_txt.text = unusualTxtStr
                unusual_btn.text = unusualBtnStr
                unusual_btn.visibility = View.VISIBLE
                unusual_img.setImageResource(R.mipmap.im_default_hudong)
            }
        }

        unusual_btn.setOnClickListener {
            mListener?.onButtonClick()
        }
    }

    interface ChatUnusualListener {
        fun onButtonClick()
    }

}